/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.config;

import de.digitalcollections.iiif.model.jackson.IiifObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

@Configuration
public class SpringConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringConfig.class);

    @Bean(name={"messageSource"})
    public MessageSource configureMessageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasenames(new String[]{"classpath:messages", "classpath:messages-overlay", "classpath:messages-commons"});
        messageSource.setCacheSeconds(5);
        messageSource.setDefaultEncoding("UTF-8");
        return messageSource;
    }

    @Bean
    @Primary
    public IiifObjectMapper objectMapper() {
        IiifObjectMapper objectMapper = new IiifObjectMapper();
        return objectMapper;
    }
}

