/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import de.digitalcollections.iiif.hymir.image.backend.impl.repository.jpegtran.v2.LibraryLoader;
import java.io.IOException;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJException;
import org.libjpegturbo.turbojpeg.TJTransform;

public class TJTransformer
extends TJDecompressor {
    private int[] transformedSizes = null;

    public TJTransformer() throws TJException {
        this.init();
    }

    public TJTransformer(byte[] jpegImage) throws TJException {
        this.init();
        this.setSourceImage(jpegImage, jpegImage.length);
    }

    public TJTransformer(byte[] jpegImage, int imageSize) throws TJException {
        this.init();
        this.setSourceImage(jpegImage, imageSize);
    }

    public void transform(byte[][] dstBufs, TJTransform[] transforms, int flags) throws TJException {
        if (this.jpegBuf == null) {
            throw new IllegalStateException("JPEG buffer not initialized");
        }
        this.transformedSizes = this.transform(this.jpegBuf, this.jpegBufSize, dstBufs, transforms, flags);
    }

    public TJDecompressor[] transform(TJTransform[] transforms, int flags) throws TJException {
        byte[][] dstBufs = new byte[transforms.length][];
        if (this.jpegWidth < 1 || this.jpegHeight < 1) {
            throw new IllegalStateException("JPEG buffer not initialized");
        }
        for (int i = 0; i < transforms.length; ++i) {
            int w = this.jpegWidth;
            int h = this.jpegHeight;
            if ((transforms[i].options & 4) != 0) {
                if (transforms[i].width != 0) {
                    w = transforms[i].width;
                }
                if (transforms[i].height != 0) {
                    h = transforms[i].height;
                }
            }
            dstBufs[i] = new byte[TJ.bufSize((int)w, (int)h, (int)this.jpegSubsamp)];
        }
        TJDecompressor[] tjd = new TJDecompressor[transforms.length];
        this.transform((byte[][])dstBufs, transforms, flags);
        for (int i = 0; i < transforms.length; ++i) {
            tjd[i] = new TJDecompressor(dstBufs[i], this.transformedSizes[i]);
        }
        return tjd;
    }

    public int[] getTransformedSizes() {
        if (this.transformedSizes == null) {
            throw new IllegalStateException("No image has been transformed yet");
        }
        return this.transformedSizes;
    }

    private native void init() throws TJException;

    private native int[] transform(byte[] var1, int var2, byte[][] var3, TJTransform[] var4, int var5) throws TJException;

    static {
        try {
            LibraryLoader.loadLibrary((String)"turbojpeg-jni");
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }
}

