/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import de.digitalcollections.iiif.hymir.image.backend.impl.repository.jpegtran.v2.LibraryLoader;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteOrder;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJException;
import org.libjpegturbo.turbojpeg.TJScalingFactor;
import org.libjpegturbo.turbojpeg.YUVImage;

public class TJDecompressor
implements Closeable {
    private static final String NO_ASSOC_ERROR = "No JPEG image is associated with this instance";
    protected long handle = 0L;
    protected byte[] jpegBuf = null;
    protected int jpegBufSize = 0;
    protected YUVImage yuvImage = null;
    protected int jpegWidth = 0;
    protected int jpegHeight = 0;
    protected int jpegSubsamp = -1;
    protected int jpegColorspace = -1;
    private ByteOrder byteOrder = null;

    public TJDecompressor() throws TJException {
        this.init();
    }

    public TJDecompressor(byte[] jpegImage) throws TJException {
        this.init();
        this.setSourceImage(jpegImage, jpegImage.length);
    }

    public TJDecompressor(byte[] jpegImage, int imageSize) throws TJException {
        this.init();
        this.setSourceImage(jpegImage, imageSize);
    }

    public TJDecompressor(YUVImage yuvImage) throws TJException {
        this.init();
        this.setSourceImage(yuvImage);
    }

    public void setSourceImage(byte[] jpegImage, int imageSize) throws TJException {
        if (jpegImage == null || imageSize < 1) {
            throw new IllegalArgumentException("Invalid argument in setSourceImage()");
        }
        this.jpegBuf = jpegImage;
        this.jpegBufSize = imageSize;
        this.decompressHeader(this.jpegBuf, this.jpegBufSize);
        this.yuvImage = null;
    }

    @Deprecated
    public void setJPEGImage(byte[] jpegImage, int imageSize) throws TJException {
        this.setSourceImage(jpegImage, imageSize);
    }

    public void setSourceImage(YUVImage srcImage) {
        if (srcImage == null) {
            throw new IllegalArgumentException("Invalid argument in setSourceImage()");
        }
        this.yuvImage = srcImage;
        this.jpegBuf = null;
        this.jpegBufSize = 0;
    }

    public int getWidth() {
        if (this.yuvImage != null) {
            return this.yuvImage.getWidth();
        }
        if (this.jpegWidth < 1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return this.jpegWidth;
    }

    public int getHeight() {
        if (this.yuvImage != null) {
            return this.yuvImage.getHeight();
        }
        if (this.jpegHeight < 1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return this.jpegHeight;
    }

    public int getSubsamp() {
        if (this.yuvImage != null) {
            return this.yuvImage.getSubsamp();
        }
        if (this.jpegSubsamp < 0) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (this.jpegSubsamp >= 6) {
            throw new IllegalStateException("JPEG header information is invalid");
        }
        return this.jpegSubsamp;
    }

    public int getColorspace() {
        if (this.yuvImage != null) {
            return 1;
        }
        if (this.jpegColorspace < 0) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (this.jpegColorspace >= 5) {
            throw new IllegalStateException("JPEG header information is invalid");
        }
        return this.jpegColorspace;
    }

    public byte[] getJPEGBuf() {
        if (this.jpegBuf == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return this.jpegBuf;
    }

    public int getJPEGSize() {
        if (this.jpegBufSize < 1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        return this.jpegBufSize;
    }

    public int getScaledWidth(int desiredWidth, int desiredHeight) {
        if (this.jpegWidth < 1 || this.jpegHeight < 1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (desiredWidth < 0 || desiredHeight < 0) {
            throw new IllegalArgumentException("Invalid argument in getScaledWidth()");
        }
        TJScalingFactor[] sf = TJ.getScalingFactors();
        if (desiredWidth == 0) {
            desiredWidth = this.jpegWidth;
        }
        if (desiredHeight == 0) {
            desiredHeight = this.jpegHeight;
        }
        int scaledWidth = this.jpegWidth;
        int scaledHeight = this.jpegHeight;
        for (int i = 0; i < sf.length; ++i) {
            scaledWidth = sf[i].getScaled(this.jpegWidth);
            scaledHeight = sf[i].getScaled(this.jpegHeight);
            if (scaledWidth <= desiredWidth && scaledHeight <= desiredHeight) break;
        }
        if (scaledWidth > desiredWidth || scaledHeight > desiredHeight) {
            throw new IllegalArgumentException("Could not scale down to desired image dimensions");
        }
        return scaledWidth;
    }

    public int getScaledHeight(int desiredWidth, int desiredHeight) {
        if (this.jpegWidth < 1 || this.jpegHeight < 1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (desiredWidth < 0 || desiredHeight < 0) {
            throw new IllegalArgumentException("Invalid argument in getScaledHeight()");
        }
        TJScalingFactor[] sf = TJ.getScalingFactors();
        if (desiredWidth == 0) {
            desiredWidth = this.jpegWidth;
        }
        if (desiredHeight == 0) {
            desiredHeight = this.jpegHeight;
        }
        int scaledWidth = this.jpegWidth;
        int scaledHeight = this.jpegHeight;
        for (int i = 0; i < sf.length; ++i) {
            scaledWidth = sf[i].getScaled(this.jpegWidth);
            scaledHeight = sf[i].getScaled(this.jpegHeight);
            if (scaledWidth <= desiredWidth && scaledHeight <= desiredHeight) break;
        }
        if (scaledWidth > desiredWidth || scaledHeight > desiredHeight) {
            throw new IllegalArgumentException("Could not scale down to desired image dimensions");
        }
        return scaledHeight;
    }

    public void decompress(byte[] dstBuf, int x, int y, int desiredWidth, int pitch, int desiredHeight, int pixelFormat, int flags) throws TJException {
        if (this.jpegBuf == null && this.yuvImage == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (dstBuf == null || x < 0 || y < 0 || pitch < 0 || this.yuvImage != null && (desiredWidth < 0 || desiredHeight < 0) || pixelFormat < 0 || pixelFormat >= 12 || flags < 0) {
            throw new IllegalArgumentException("Invalid argument in decompress()");
        }
        if (this.yuvImage != null) {
            this.decodeYUV(this.yuvImage.getPlanes(), this.yuvImage.getOffsets(), this.yuvImage.getStrides(), this.yuvImage.getSubsamp(), dstBuf, x, y, this.yuvImage.getWidth(), pitch, this.yuvImage.getHeight(), pixelFormat, flags);
        } else if (x > 0 || y > 0) {
            this.decompress(this.jpegBuf, this.jpegBufSize, dstBuf, x, y, desiredWidth, pitch, desiredHeight, pixelFormat, flags);
        } else {
            this.decompress(this.jpegBuf, this.jpegBufSize, dstBuf, desiredWidth, pitch, desiredHeight, pixelFormat, flags);
        }
    }

    @Deprecated
    public void decompress(byte[] dstBuf, int desiredWidth, int pitch, int desiredHeight, int pixelFormat, int flags) throws TJException {
        this.decompress(dstBuf, 0, 0, desiredWidth, pitch, desiredHeight, pixelFormat, flags);
    }

    public byte[] decompress(int desiredWidth, int pitch, int desiredHeight, int pixelFormat, int flags) throws TJException {
        if (pitch < 0 || this.yuvImage == null && (desiredWidth < 0 || desiredHeight < 0) || pixelFormat < 0 || pixelFormat >= 12 || flags < 0) {
            throw new IllegalArgumentException("Invalid argument in decompress()");
        }
        int pixelSize = TJ.getPixelSize((int)pixelFormat);
        int scaledWidth = this.getScaledWidth(desiredWidth, desiredHeight);
        int scaledHeight = this.getScaledHeight(desiredWidth, desiredHeight);
        if (pitch == 0) {
            pitch = scaledWidth * pixelSize;
        }
        byte[] buf = new byte[pitch * scaledHeight];
        this.decompress(buf, desiredWidth, pitch, desiredHeight, pixelFormat, flags);
        return buf;
    }

    public void decompressToYUV(YUVImage dstImage, int flags) throws TJException {
        if (this.jpegBuf == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (dstImage == null || flags < 0) {
            throw new IllegalArgumentException("Invalid argument in decompressToYUV()");
        }
        int scaledWidth = this.getScaledWidth(dstImage.getWidth(), dstImage.getHeight());
        int scaledHeight = this.getScaledHeight(dstImage.getWidth(), dstImage.getHeight());
        if (scaledWidth != dstImage.getWidth() || scaledHeight != dstImage.getHeight()) {
            throw new IllegalArgumentException("YUVImage dimensions do not match one of the scaled image sizes that TurboJPEG is capable of generating.");
        }
        if (this.jpegSubsamp != dstImage.getSubsamp()) {
            throw new IllegalArgumentException("YUVImage subsampling level does not match that of the JPEG image");
        }
        this.decompressToYUV(this.jpegBuf, this.jpegBufSize, dstImage.getPlanes(), dstImage.getOffsets(), dstImage.getWidth(), dstImage.getStrides(), dstImage.getHeight(), flags);
    }

    @Deprecated
    public void decompressToYUV(byte[] dstBuf, int flags) throws TJException {
        YUVImage dstImage = new YUVImage(dstBuf, this.jpegWidth, 4, this.jpegHeight, this.jpegSubsamp);
        this.decompressToYUV(dstImage, flags);
    }

    public YUVImage decompressToYUV(int desiredWidth, int[] strides, int desiredHeight, int flags) throws TJException {
        if (flags < 0) {
            throw new IllegalArgumentException("Invalid argument in decompressToYUV()");
        }
        if (this.jpegWidth < 1 || this.jpegHeight < 1 || this.jpegSubsamp < 0) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (this.jpegSubsamp >= 6) {
            throw new IllegalStateException("JPEG header information is invalid");
        }
        if (this.yuvImage != null) {
            throw new IllegalStateException("Source image is the wrong type");
        }
        int scaledWidth = this.getScaledWidth(desiredWidth, desiredHeight);
        int scaledHeight = this.getScaledHeight(desiredWidth, desiredHeight);
        YUVImage yuvImage = new YUVImage(scaledWidth, null, scaledHeight, this.jpegSubsamp);
        this.decompressToYUV(yuvImage, flags);
        return yuvImage;
    }

    public YUVImage decompressToYUV(int desiredWidth, int pad, int desiredHeight, int flags) throws TJException {
        if (flags < 0) {
            throw new IllegalArgumentException("Invalid argument in decompressToYUV()");
        }
        if (this.jpegWidth < 1 || this.jpegHeight < 1 || this.jpegSubsamp < 0) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (this.jpegSubsamp >= 6) {
            throw new IllegalStateException("JPEG header information is invalid");
        }
        if (this.yuvImage != null) {
            throw new IllegalStateException("Source image is the wrong type");
        }
        int scaledWidth = this.getScaledWidth(desiredWidth, desiredHeight);
        int scaledHeight = this.getScaledHeight(desiredWidth, desiredHeight);
        YUVImage yuvImage = new YUVImage(scaledWidth, pad, scaledHeight, this.jpegSubsamp);
        this.decompressToYUV(yuvImage, flags);
        return yuvImage;
    }

    @Deprecated
    public byte[] decompressToYUV(int flags) throws TJException {
        YUVImage dstImage = new YUVImage(this.jpegWidth, 4, this.jpegHeight, this.jpegSubsamp);
        this.decompressToYUV(dstImage, flags);
        return dstImage.getBuf();
    }

    public void decompress(int[] dstBuf, int x, int y, int desiredWidth, int stride, int desiredHeight, int pixelFormat, int flags) throws TJException {
        if (this.jpegBuf == null && this.yuvImage == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (dstBuf == null || x < 0 || y < 0 || stride < 0 || this.yuvImage != null && (desiredWidth < 0 || desiredHeight < 0) || pixelFormat < 0 || pixelFormat >= 12 || flags < 0) {
            throw new IllegalArgumentException("Invalid argument in decompress()");
        }
        if (this.yuvImage != null) {
            this.decodeYUV(this.yuvImage.getPlanes(), this.yuvImage.getOffsets(), this.yuvImage.getStrides(), this.yuvImage.getSubsamp(), dstBuf, x, y, this.yuvImage.getWidth(), stride, this.yuvImage.getHeight(), pixelFormat, flags);
        } else {
            this.decompress(this.jpegBuf, this.jpegBufSize, dstBuf, x, y, desiredWidth, stride, desiredHeight, pixelFormat, flags);
        }
    }

    public void decompress(BufferedImage dstImage, int flags) throws TJException {
        int pixelFormat;
        int scaledHeight;
        int scaledWidth;
        if (dstImage == null || flags < 0) {
            throw new IllegalArgumentException("Invalid argument in decompress()");
        }
        int desiredWidth = dstImage.getWidth();
        int desiredHeight = dstImage.getHeight();
        if (this.yuvImage != null) {
            if (desiredWidth != this.yuvImage.getWidth() || desiredHeight != this.yuvImage.getHeight()) {
                throw new IllegalArgumentException("BufferedImage dimensions do not match the dimensions of the source image.");
            }
            scaledWidth = this.yuvImage.getWidth();
            scaledHeight = this.yuvImage.getHeight();
        } else {
            scaledWidth = this.getScaledWidth(desiredWidth, desiredHeight);
            scaledHeight = this.getScaledHeight(desiredWidth, desiredHeight);
            if (scaledWidth != desiredWidth || scaledHeight != desiredHeight) {
                throw new IllegalArgumentException("BufferedImage dimensions do not match one of the scaled image sizes that TurboJPEG is capable of generating.");
            }
        }
        boolean intPixels = false;
        if (this.byteOrder == null) {
            this.byteOrder = ByteOrder.nativeOrder();
        }
        switch (dstImage.getType()) {
            case 5: {
                pixelFormat = 1;
                break;
            }
            case 6: 
            case 7: {
                pixelFormat = 4;
                break;
            }
            case 10: {
                pixelFormat = 6;
                break;
            }
            case 4: {
                pixelFormat = this.byteOrder == ByteOrder.BIG_ENDIAN ? 4 : 2;
                intPixels = true;
                break;
            }
            case 1: {
                pixelFormat = this.byteOrder == ByteOrder.BIG_ENDIAN ? 5 : 3;
                intPixels = true;
                break;
            }
            case 2: 
            case 3: {
                pixelFormat = this.byteOrder == ByteOrder.BIG_ENDIAN ? 10 : 8;
                intPixels = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported BufferedImage format");
            }
        }
        WritableRaster wr = dstImage.getRaster();
        if (intPixels) {
            SinglePixelPackedSampleModel sm = (SinglePixelPackedSampleModel)dstImage.getSampleModel();
            int stride = sm.getScanlineStride();
            DataBufferInt db = (DataBufferInt)wr.getDataBuffer();
            int[] buf = db.getData();
            if (this.yuvImage != null) {
                this.decodeYUV(this.yuvImage.getPlanes(), this.yuvImage.getOffsets(), this.yuvImage.getStrides(), this.yuvImage.getSubsamp(), buf, 0, 0, this.yuvImage.getWidth(), stride, this.yuvImage.getHeight(), pixelFormat, flags);
            } else {
                if (this.jpegBuf == null) {
                    throw new IllegalStateException(NO_ASSOC_ERROR);
                }
                this.decompress(this.jpegBuf, this.jpegBufSize, buf, 0, 0, scaledWidth, stride, scaledHeight, pixelFormat, flags);
            }
        } else {
            ComponentSampleModel sm = (ComponentSampleModel)dstImage.getSampleModel();
            int pixelSize = sm.getPixelStride();
            if (pixelSize != TJ.getPixelSize((int)pixelFormat)) {
                throw new IllegalArgumentException("Inconsistency between pixel format and pixel size in BufferedImage");
            }
            int pitch = sm.getScanlineStride();
            DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
            byte[] buf = db.getData();
            this.decompress(buf, 0, 0, scaledWidth, pitch, scaledHeight, pixelFormat, flags);
        }
    }

    public BufferedImage decompress(int desiredWidth, int desiredHeight, int bufferedImageType, int flags) throws TJException {
        if (this.yuvImage == null && (desiredWidth < 0 || desiredHeight < 0) || flags < 0) {
            throw new IllegalArgumentException("Invalid argument in decompress()");
        }
        int scaledWidth = this.getScaledWidth(desiredWidth, desiredHeight);
        int scaledHeight = this.getScaledHeight(desiredWidth, desiredHeight);
        BufferedImage img = new BufferedImage(scaledWidth, scaledHeight, bufferedImageType);
        this.decompress(img, flags);
        return img;
    }

    @Override
    public void close() throws TJException {
        if (this.handle != 0L) {
            this.destroy();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (TJException tJException) {
        }
        finally {
            super.finalize();
        }
    }

    private native void init() throws TJException;

    private native void destroy() throws TJException;

    private native void decompressHeader(byte[] var1, int var2) throws TJException;

    @Deprecated
    private native void decompress(byte[] var1, int var2, byte[] var3, int var4, int var5, int var6, int var7, int var8) throws TJException;

    private native void decompress(byte[] var1, int var2, byte[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10) throws TJException;

    @Deprecated
    private native void decompress(byte[] var1, int var2, int[] var3, int var4, int var5, int var6, int var7, int var8) throws TJException;

    private native void decompress(byte[] var1, int var2, int[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10) throws TJException;

    @Deprecated
    private native void decompressToYUV(byte[] var1, int var2, byte[] var3, int var4) throws TJException;

    private native void decompressToYUV(byte[] var1, int var2, byte[][] var3, int[] var4, int var5, int[] var6, int var7, int var8) throws TJException;

    private native void decodeYUV(byte[][] var1, int[] var2, int[] var3, int var4, byte[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12) throws TJException;

    private native void decodeYUV(byte[][] var1, int[] var2, int[] var3, int var4, int[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12) throws TJException;

    static {
        try {
            LibraryLoader.loadLibrary((String)"turbojpeg-jni");
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }
}

