/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import de.digitalcollections.iiif.hymir.image.backend.impl.repository.jpegtran.v2.LibraryLoader;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteOrder;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJException;
import org.libjpegturbo.turbojpeg.YUVImage;

public class TJCompressor
implements Closeable {
    private static final String NO_ASSOC_ERROR = "No source image is associated with this instance";
    private final long handle = 0L;
    private byte[] srcBuf = null;
    private int[] srcBufInt = null;
    private int srcWidth = 0;
    private int srcHeight = 0;
    private int srcX = -1;
    private int srcY = -1;
    private int srcPitch = 0;
    private int srcStride = 0;
    private int srcPixelFormat = -1;
    private YUVImage srcYUVImage = null;
    private int subsamp = -1;
    private int jpegQuality = -1;
    private int compressedSize = 0;
    private ByteOrder byteOrder = null;

    public TJCompressor() throws TJException {
        this.init();
    }

    public TJCompressor(byte[] srcImage, int x, int y, int width, int pitch, int height, int pixelFormat) throws TJException {
        this.setSourceImage(srcImage, x, y, width, pitch, height, pixelFormat);
    }

    @Deprecated
    public TJCompressor(byte[] srcImage, int width, int pitch, int height, int pixelFormat) throws TJException {
        this.setSourceImage(srcImage, width, pitch, height, pixelFormat);
    }

    public TJCompressor(BufferedImage srcImage, int x, int y, int width, int height) throws TJException {
        this.setSourceImage(srcImage, x, y, width, height);
    }

    public void setSourceImage(byte[] srcImage, int x, int y, int width, int pitch, int height, int pixelFormat) throws TJException {
        this.init();
        if (srcImage == null || x < 0 || y < 0 || width < 1 || height < 1 || pitch < 0 || pixelFormat < 0 || pixelFormat >= 12) {
            throw new IllegalArgumentException("Invalid argument in setSourceImage()");
        }
        this.srcBuf = srcImage;
        this.srcWidth = width;
        this.srcPitch = pitch == 0 ? width * TJ.getPixelSize((int)pixelFormat) : pitch;
        this.srcHeight = height;
        this.srcPixelFormat = pixelFormat;
        this.srcX = x;
        this.srcY = y;
        this.srcBufInt = null;
        this.srcYUVImage = null;
    }

    @Deprecated
    public void setSourceImage(byte[] srcImage, int width, int pitch, int height, int pixelFormat) throws TJException {
        this.setSourceImage(srcImage, 0, 0, width, pitch, height, pixelFormat);
        this.srcY = -1;
        this.srcX = -1;
    }

    public void setSourceImage(BufferedImage srcImage, int x, int y, int width, int height) throws TJException {
        int pixelFormat;
        this.init();
        if (srcImage == null || x < 0 || y < 0 || width < 0 || height < 0) {
            throw new IllegalArgumentException("Invalid argument in setSourceImage()");
        }
        this.srcX = x;
        this.srcY = y;
        this.srcWidth = width == 0 ? srcImage.getWidth() : width;
        int n = this.srcHeight = height == 0 ? srcImage.getHeight() : height;
        if (x + width > srcImage.getWidth() || y + height > srcImage.getHeight()) {
            throw new IllegalArgumentException("Compression region exceeds the bounds of the source image");
        }
        boolean intPixels = false;
        if (this.byteOrder == null) {
            this.byteOrder = ByteOrder.nativeOrder();
        }
        switch (srcImage.getType()) {
            case 5: {
                pixelFormat = 1;
                break;
            }
            case 6: 
            case 7: {
                pixelFormat = 4;
                break;
            }
            case 10: {
                pixelFormat = 6;
                break;
            }
            case 4: {
                pixelFormat = this.byteOrder == ByteOrder.BIG_ENDIAN ? 4 : 2;
                intPixels = true;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                pixelFormat = this.byteOrder == ByteOrder.BIG_ENDIAN ? 5 : 3;
                intPixels = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported BufferedImage format");
            }
        }
        this.srcPixelFormat = pixelFormat;
        WritableRaster wr = srcImage.getRaster();
        if (intPixels) {
            SinglePixelPackedSampleModel sm = (SinglePixelPackedSampleModel)srcImage.getSampleModel();
            this.srcStride = sm.getScanlineStride();
            DataBufferInt db = (DataBufferInt)wr.getDataBuffer();
            this.srcBufInt = db.getData();
            this.srcBuf = null;
        } else {
            ComponentSampleModel sm = (ComponentSampleModel)srcImage.getSampleModel();
            int pixelSize = sm.getPixelStride();
            if (pixelSize != TJ.getPixelSize((int)pixelFormat)) {
                throw new IllegalArgumentException("Inconsistency between pixel format and pixel size in BufferedImage");
            }
            this.srcPitch = sm.getScanlineStride();
            DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
            this.srcBuf = db.getData();
            this.srcBufInt = null;
        }
        this.srcYUVImage = null;
    }

    public void setSourceImage(YUVImage srcImage) throws TJException {
        this.init();
        if (srcImage == null) {
            throw new IllegalArgumentException("Invalid argument in setSourceImage()");
        }
        this.srcYUVImage = srcImage;
        this.srcBuf = null;
        this.srcBufInt = null;
    }

    public void setSubsamp(int newSubsamp) {
        if (newSubsamp < 0 || newSubsamp >= 6) {
            throw new IllegalArgumentException("Invalid argument in setSubsamp()");
        }
        this.subsamp = newSubsamp;
    }

    public void setJPEGQuality(int quality) {
        if (quality < 1 || quality > 100) {
            throw new IllegalArgumentException("Invalid argument in setJPEGQuality()");
        }
        this.jpegQuality = quality;
    }

    public void compress(byte[] dstBuf, int flags) throws TJException {
        if (dstBuf == null || flags < 0) {
            throw new IllegalArgumentException("Invalid argument in compress()");
        }
        if (this.srcBuf == null && this.srcBufInt == null && this.srcYUVImage == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (this.jpegQuality < 0) {
            throw new IllegalStateException("JPEG Quality not set");
        }
        if (this.subsamp < 0 && this.srcYUVImage == null) {
            throw new IllegalStateException("Subsampling level not set");
        }
        if (this.srcYUVImage != null) {
            this.compressedSize = this.compressFromYUV(this.srcYUVImage.getPlanes(), this.srcYUVImage.getOffsets(), this.srcYUVImage.getWidth(), this.srcYUVImage.getStrides(), this.srcYUVImage.getHeight(), this.srcYUVImage.getSubsamp(), dstBuf, this.jpegQuality, flags);
        } else if (this.srcBuf != null) {
            this.compressedSize = this.srcX >= 0 && this.srcY >= 0 ? this.compress(this.srcBuf, this.srcX, this.srcY, this.srcWidth, this.srcPitch, this.srcHeight, this.srcPixelFormat, dstBuf, this.subsamp, this.jpegQuality, flags) : this.compress(this.srcBuf, this.srcWidth, this.srcPitch, this.srcHeight, this.srcPixelFormat, dstBuf, this.subsamp, this.jpegQuality, flags);
        } else if (this.srcBufInt != null) {
            this.compressedSize = this.srcX >= 0 && this.srcY >= 0 ? this.compress(this.srcBufInt, this.srcX, this.srcY, this.srcWidth, this.srcStride, this.srcHeight, this.srcPixelFormat, dstBuf, this.subsamp, this.jpegQuality, flags) : this.compress(this.srcBufInt, this.srcWidth, this.srcStride, this.srcHeight, this.srcPixelFormat, dstBuf, this.subsamp, this.jpegQuality, flags);
        }
    }

    public byte[] compress(int flags) throws TJException {
        this.checkSourceImage();
        byte[] buf = new byte[TJ.bufSize((int)this.srcWidth, (int)this.srcHeight, (int)this.subsamp)];
        this.compress(buf, flags);
        return buf;
    }

    @Deprecated
    public void compress(BufferedImage srcImage, byte[] dstBuf, int flags) throws TJException {
        this.setSourceImage(srcImage, 0, 0, 0, 0);
        this.compress(dstBuf, flags);
    }

    @Deprecated
    public byte[] compress(BufferedImage srcImage, int flags) throws TJException {
        this.setSourceImage(srcImage, 0, 0, 0, 0);
        return this.compress(flags);
    }

    public void encodeYUV(YUVImage dstImage, int flags) throws TJException {
        if (dstImage == null || flags < 0) {
            throw new IllegalArgumentException("Invalid argument in encodeYUV()");
        }
        if (this.srcBuf == null && this.srcBufInt == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (this.srcYUVImage != null) {
            throw new IllegalStateException("Source image is not correct type");
        }
        this.checkSubsampling();
        if (this.srcWidth != dstImage.getWidth() || this.srcHeight != dstImage.getHeight()) {
            throw new IllegalStateException("Destination image is the wrong size");
        }
        if (this.srcBufInt != null) {
            this.encodeYUV(this.srcBufInt, this.srcX, this.srcY, this.srcWidth, this.srcStride, this.srcHeight, this.srcPixelFormat, dstImage.getPlanes(), dstImage.getOffsets(), dstImage.getStrides(), dstImage.getSubsamp(), flags);
        } else {
            this.encodeYUV(this.srcBuf, this.srcX, this.srcY, this.srcWidth, this.srcPitch, this.srcHeight, this.srcPixelFormat, dstImage.getPlanes(), dstImage.getOffsets(), dstImage.getStrides(), dstImage.getSubsamp(), flags);
        }
        this.compressedSize = 0;
    }

    @Deprecated
    public void encodeYUV(byte[] dstBuf, int flags) throws TJException {
        if (dstBuf == null) {
            throw new IllegalArgumentException("Invalid argument in encodeYUV()");
        }
        this.checkSourceImage();
        this.checkSubsampling();
        YUVImage yuvImage = new YUVImage(dstBuf, this.srcWidth, 4, this.srcHeight, this.subsamp);
        this.encodeYUV(yuvImage, flags);
    }

    public YUVImage encodeYUV(int pad, int flags) throws TJException {
        this.checkSourceImage();
        this.checkSubsampling();
        if (pad < 1 || (pad & pad - 1) != 0) {
            throw new IllegalStateException("Invalid argument in encodeYUV()");
        }
        YUVImage yuvImage = new YUVImage(this.srcWidth, pad, this.srcHeight, this.subsamp);
        this.encodeYUV(yuvImage, flags);
        return yuvImage;
    }

    public YUVImage encodeYUV(int[] strides, int flags) throws TJException {
        this.checkSourceImage();
        this.checkSubsampling();
        YUVImage yuvImage = new YUVImage(this.srcWidth, strides, this.srcHeight, this.subsamp);
        this.encodeYUV(yuvImage, flags);
        return yuvImage;
    }

    @Deprecated
    public byte[] encodeYUV(int flags) throws TJException {
        this.checkSourceImage();
        this.checkSubsampling();
        YUVImage yuvImage = new YUVImage(this.srcWidth, 4, this.srcHeight, this.subsamp);
        this.encodeYUV(yuvImage, flags);
        return yuvImage.getBuf();
    }

    @Deprecated
    public void encodeYUV(BufferedImage srcImage, byte[] dstBuf, int flags) throws TJException {
        this.setSourceImage(srcImage, 0, 0, 0, 0);
        this.encodeYUV(dstBuf, flags);
    }

    @Deprecated
    public byte[] encodeYUV(BufferedImage srcImage, int flags) throws TJException {
        this.setSourceImage(srcImage, 0, 0, 0, 0);
        return this.encodeYUV(flags);
    }

    public int getCompressedSize() {
        return this.compressedSize;
    }

    @Override
    public void close() throws TJException {
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (TJException tJException) {
        }
        finally {
            super.finalize();
        }
    }

    private native void init() throws TJException;

    private native void destroy() throws TJException;

    @Deprecated
    private native int compress(byte[] var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, int var9) throws TJException;

    private native int compress(byte[] var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[] var8, int var9, int var10, int var11) throws TJException;

    @Deprecated
    private native int compress(int[] var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, int var9) throws TJException;

    private native int compress(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[] var8, int var9, int var10, int var11) throws TJException;

    private native int compressFromYUV(byte[][] var1, int[] var2, int var3, int[] var4, int var5, int var6, byte[] var7, int var8, int var9) throws TJException;

    @Deprecated
    private native void encodeYUV(byte[] var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8) throws TJException;

    private native void encodeYUV(byte[] var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[][] var8, int[] var9, int[] var10, int var11, int var12) throws TJException;

    @Deprecated
    private native void encodeYUV(int[] var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8) throws TJException;

    private native void encodeYUV(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[][] var8, int[] var9, int[] var10, int var11, int var12) throws TJException;

    private void checkSourceImage() {
        if (this.srcWidth < 1 || this.srcHeight < 1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
    }

    private void checkSubsampling() {
        if (this.subsamp < 0) {
            throw new IllegalStateException("Subsampling level not set");
        }
    }

    static {
        try {
            LibraryLoader.loadLibrary((String)"turbojpeg-jni");
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }
}

