/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.presentation.frontend.impl.springmvc.controller.v2;

import de.digitalcollections.commons.server.HttpLoggingUtilities;
import de.digitalcollections.iiif.hymir.model.api.exception.InvalidDataException;
import de.digitalcollections.iiif.hymir.model.api.exception.ResolvingException;
import de.digitalcollections.iiif.hymir.presentation.business.api.v2.PresentationService;
import de.digitalcollections.iiif.model.sharedcanvas.Canvas;
import de.digitalcollections.iiif.model.sharedcanvas.Collection;
import de.digitalcollections.iiif.model.sharedcanvas.Manifest;
import de.digitalcollections.iiif.model.sharedcanvas.Range;
import de.digitalcollections.iiif.model.sharedcanvas.Sequence;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="IIIFPresentationApiController-v2")
@RequestMapping(value={"/presentation/v2"})
public class IIIFPresentationApiController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IIIFPresentationApiController.class);
    public static final String VERSION = "v2";
    @Autowired
    private PresentationService presentationService;

    @CrossOrigin(allowedHeaders={"*"}, origins={"*"})
    @RequestMapping(value={"{identifier}/manifest", "{identifier}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Manifest getManifest(@PathVariable String identifier, HttpServletRequest request) throws ResolvingException, InvalidDataException {
        HttpLoggingUtilities.addRequestClientInfoToMDC((HttpServletRequest)request);
        MDC.put((String)"manifestId", (String)identifier);
        try {
            Manifest manifest = this.presentationService.getManifest(identifier);
            LOGGER.info("Serving manifest for {}", (Object)identifier);
            Manifest manifest2 = manifest;
            return manifest2;
        }
        catch (ResolvingException e) {
            LOGGER.info("Did not find manifest for {}", (Object)identifier);
            throw e;
        }
        catch (InvalidDataException e) {
            LOGGER.error("Bad data for {}", (Object)identifier);
            throw e;
        }
        finally {
            MDC.clear();
        }
    }

    @CrossOrigin(allowedHeaders={"*"}, origins={"*"})
    @RequestMapping(value={"{identifier}/manifest", "{identifier}"}, method={RequestMethod.HEAD})
    @ResponseBody
    public void checkManifest(@PathVariable String identifier, HttpServletResponse response) throws ResolvingException, InvalidDataException {
        this.presentationService.getManifest(identifier);
        response.setStatus(200);
    }

    @CrossOrigin(allowedHeaders={"*"}, origins={"*"})
    @RequestMapping(value={"{manifestId}/canvas/{canvasId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Canvas getCanvas(@PathVariable String manifestId, @PathVariable String canvasId, HttpServletRequest req) throws ResolvingException, InvalidDataException {
        return this.presentationService.getCanvas(manifestId, this.getOriginalUri(req));
    }

    @CrossOrigin(allowedHeaders={"*"}, origins={"*"})
    @RequestMapping(value={"{manifestId}/range/{rangeId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Range getRange(@PathVariable String manifestId, @PathVariable String rangeId, HttpServletRequest req) throws ResolvingException, InvalidDataException {
        return this.presentationService.getRange(manifestId, this.getOriginalUri(req));
    }

    @CrossOrigin(allowedHeaders={"*"}, origins={"*"})
    @RequestMapping(value={"{manifestId}/sequence/{sequenceId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Sequence getSequence(@PathVariable String manifestId, @PathVariable String sequenceId, HttpServletRequest req) throws ResolvingException, InvalidDataException {
        return this.presentationService.getSequence(manifestId, this.getOriginalUri(req));
    }

    @CrossOrigin(allowedHeaders={"*"}, origins={"*"})
    @RequestMapping(value={"collection/{name}"}, method={RequestMethod.GET, RequestMethod.HEAD}, produces={"application/json"})
    @ResponseBody
    public Collection getCollection(@PathVariable String name, HttpServletRequest request) throws ResolvingException, InvalidDataException {
        HttpLoggingUtilities.addRequestClientInfoToMDC((HttpServletRequest)request);
        MDC.put((String)"collection name", (String)name);
        try {
            Collection collection = this.presentationService.getCollection(name);
            LOGGER.info("Serving collection for {}", (Object)name);
            Collection collection2 = collection;
            return collection2;
        }
        catch (ResolvingException e) {
            LOGGER.info("Did not find collection for {}", (Object)name);
            throw e;
        }
        catch (InvalidDataException e) {
            LOGGER.info("Bad data for {}", (Object)name);
            throw e;
        }
        finally {
            MDC.clear();
        }
    }

    private URI getOriginalUri(HttpServletRequest request) {
        String requestUrl = request.getRequestURL().toString();
        String incomingScheme = URI.create(requestUrl).getScheme();
        String originalScheme = request.getHeader("X-Forwarded-Proto");
        if (originalScheme != null && !incomingScheme.equals(originalScheme)) {
            return URI.create(requestUrl.replaceFirst("^" + incomingScheme, originalScheme));
        }
        return URI.create(requestUrl);
    }
}

