/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.image.backend.impl.repository.v2;

import de.digitalcollections.iiif.hymir.image.backend.impl.repository.imageio.v2.JAIImage;
import de.digitalcollections.iiif.hymir.image.backend.impl.repository.v2.AbstractImageRepositoryImpl;
import de.digitalcollections.iiif.hymir.image.backend.impl.repository.v2.ImageRepositoryImageIoImpl;
import de.digitalcollections.iiif.hymir.image.model.api.enums.ImageBitDepth;
import de.digitalcollections.iiif.hymir.image.model.api.enums.ImageFormat;
import de.digitalcollections.iiif.hymir.image.model.api.v2.Image;
import de.digitalcollections.iiif.hymir.image.model.api.v2.RegionParameters;
import de.digitalcollections.iiif.hymir.image.model.api.v2.ResizeParameters;
import de.digitalcollections.iiif.hymir.model.api.exception.ResolvingException;
import de.digitalcollections.iiif.hymir.model.api.exception.UnsupportedFormatException;
import java.awt.Dimension;
import java.io.IOException;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="ImageRepositoryImageIoImpl-v2.0.0")
public class ImageRepositoryImageIoImpl
extends AbstractImageRepositoryImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageRepositoryImageIoImpl.class);

    protected Image createImage(String identifier, RegionParameters regionParameters) throws ResolvingException, UnsupportedFormatException, IOException {
        LOGGER.debug("Loading image {} with ImageIO imlementation.", (Object)identifier);
        byte[] imageData = this.imageDataRepository.getImageData(identifier);
        return new JAIImage(imageData, regionParameters);
    }

    public boolean supportsInputFormat(ImageFormat inFormat) {
        return Stream.of(ImageIO.getReaderFormatNames()).anyMatch(name -> {
            try {
                return JAIImage.getFormatFromString((String)name).equals((Object)inFormat);
            }
            catch (UnsupportedFormatException e) {
                return false;
            }
        });
    }

    public boolean supportsOutputFormat(ImageFormat outFormat) {
        return Stream.of(ImageIO.getWriterFormatNames()).anyMatch(name -> {
            try {
                return JAIImage.getFormatFromString((String)name).equals((Object)outFormat);
            }
            catch (UnsupportedFormatException e) {
                return false;
            }
        });
    }

    public boolean supportsCropOperation(RegionParameters region) {
        return true;
    }

    public boolean supportsScaleOperation(Dimension imageDims, ResizeParameters scaleParams) {
        return true;
    }

    public boolean supportsBitDepth(ImageBitDepth bitDepth) {
        if (bitDepth == null) {
            return true;
        }
        switch (1.$SwitchMap$de$digitalcollections$iiif$hymir$image$model$api$enums$ImageBitDepth[bitDepth.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }
}

