/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.image.backend.impl.repository.jpegtran.v2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LibraryLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibrary(String name) throws IOException {
        try {
            System.loadLibrary(name);
        }
        catch (UnsatisfiedLinkError e) {
            String filename = System.mapLibraryName(name);
            InputStream in = LibraryLoader.class.getClassLoader().getResourceAsStream(filename);
            int pos = filename.lastIndexOf(46);
            File file = File.createTempFile(filename.substring(0, pos), filename.substring(pos));
            file.deleteOnExit();
            try {
                byte[] buf = new byte[4096];
                try (FileOutputStream out = new FileOutputStream(file);){
                    while (in.available() > 0) {
                        int len = in.read(buf);
                        if (len < 0) continue;
                        ((OutputStream)out).write(buf, 0, len);
                    }
                }
            }
            finally {
                in.close();
            }
            System.load(file.getAbsolutePath());
        }
    }
}

