/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.image.backend.impl.repository.jpegtran.v2;

import de.digitalcollections.iiif.hymir.image.backend.impl.repository.jpegtran.v2.JpegImage;
import de.digitalcollections.iiif.hymir.image.model.api.enums.ImageBitDepth;
import de.digitalcollections.iiif.hymir.image.model.api.enums.ImageFormat;
import de.digitalcollections.iiif.hymir.image.model.api.v2.Image;
import de.digitalcollections.iiif.hymir.image.model.api.v2.RegionParameters;
import de.digitalcollections.iiif.hymir.image.model.api.v2.ResizeParameters;
import de.digitalcollections.iiif.hymir.image.model.api.v2.TransformationException;
import de.digitalcollections.iiif.hymir.model.api.exception.InvalidParametersException;
import java.io.IOException;
import org.libjpegturbo.turbojpeg.TJException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpegTranImage
implements Image {
    private static final Logger LOGGER = LoggerFactory.getLogger(JpegTranImage.class);
    private JpegImage jpegImage;
    private int height;
    private int width;

    public JpegTranImage(byte[] imgData) throws TJException {
        this(new JpegImage(imgData));
    }

    private JpegTranImage(JpegImage image) {
        this.setBackendImage(image);
    }

    private void setBackendImage(JpegImage image) {
        this.jpegImage = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public Image flipHorizontally() {
        this.jpegImage.flipHorizontal();
        return this;
    }

    public ImageFormat getFormat() {
        return ImageFormat.JPEG;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] toByteArray() throws UnsupportedOperationException, IOException {
        return this.jpegImage.toByteArray();
    }

    public Image crop(RegionParameters params) throws InvalidParametersException {
        try {
            int height;
            int width;
            int y;
            int x;
            int origWidth = this.getWidth();
            int origHeight = this.getHeight();
            if (params.isAbsolute()) {
                x = (int)Math.ceil(params.getHorizontalOffset());
                y = (int)Math.ceil(params.getVerticalOffset());
                width = (int)Math.ceil(params.getWidth());
                height = (int)Math.ceil(params.getHeight());
            } else {
                x = (int)Math.ceil((float)this.getWidth() * params.getHorizontalOffset() / 100.0f);
                y = (int)Math.ceil((float)this.getHeight() * params.getVerticalOffset() / 100.0f);
                width = (int)Math.ceil((float)this.getWidth() * params.getWidth() / 100.0f);
                height = (int)Math.ceil((float)this.getHeight() * params.getHeight() / 100.0f);
            }
            if (x >= origWidth || y >= origHeight) {
                throw new InvalidParametersException(String.format("x and/or y out of bounds (image size is %sx%s)", origWidth, origHeight));
            }
            if (width > origWidth - x) {
                width = origWidth - x;
            }
            if (height > origHeight - y) {
                height = origHeight - y;
            }
            this.jpegImage.crop(x, y, width, height);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParametersException(e.getMessage());
        }
        return this;
    }

    public Image scale(ResizeParameters params) throws InvalidParametersException, TransformationException {
        int oldWidth = this.getWidth();
        int oldHeight = this.getHeight();
        int newWidth = (int)Math.ceil(params.getWidth());
        int newHeight = (int)Math.ceil(params.getHeight());
        try {
            if (oldWidth == newWidth && oldHeight == newHeight) {
                return this;
            }
            this.jpegImage.downScale(newWidth, newHeight, 85);
        }
        catch (IllegalArgumentException | TJException e) {
            LOGGER.error("Downscaling image failed", e);
            LOGGER.debug("Tried to scale down from {}x{} to {}x{}", new Object[]{oldWidth, oldHeight, params.getWidth(), params.getHeight()});
            throw new TransformationException("Downscaling failed", e);
        }
        return this;
    }

    public Image rotate(int arcDegree) throws InvalidParametersException {
        try {
            this.jpegImage.rotate(arcDegree);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidParametersException(e.getMessage());
        }
        return this;
    }

    public Image toDepth(ImageBitDepth depth) throws UnsupportedOperationException {
        if (depth.equals((Object)ImageBitDepth.GRAYSCALE)) {
            this.jpegImage.toGrayscale();
            return this;
        }
        throw new UnsupportedOperationException("Bit depth transformations other than grayscale are not supported.");
    }

    public Image convert(ImageFormat format) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Format conversions are not supported");
    }

    public void performTransformation() throws TransformationException {
        try {
            this.jpegImage.transform();
        }
        catch (TJException e) {
            throw new TransformationException((Throwable)e);
        }
    }
}

