/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.image.backend.impl.repository.jpegtran.v2;

import de.digitalcollections.iiif.hymir.image.backend.impl.repository.jpegtran.v2.EpegScaler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJException;
import org.libjpegturbo.turbojpeg.TJTransform;
import org.libjpegturbo.turbojpeg.TJTransformer;

public class JpegImage {
    private TJDecompressor decomp;
    private TJTransform transformOptions;
    private byte[] imgData;

    public JpegImage(URI filePath) throws IOException {
        this(IOUtils.toByteArray((URI)filePath));
    }

    public JpegImage(byte[] data) throws TJException {
        this.setImageData(data);
        this.setTransformOptions(new TJTransform());
    }

    public void setImageData(byte[] data) throws TJException {
        if ((data[0] & 0xFF) != 255 || (data[1] & 0xFF) != 216) {
            throw new IllegalArgumentException("Not a JPEG file");
        }
        this.imgData = data;
        this.decomp = new TJDecompressor(this.imgData);
    }

    public void setTransformOptions(TJTransform transformOptions) {
        this.transformOptions = transformOptions;
    }

    public int getWidth() {
        return this.decomp.getWidth();
    }

    public int getHeight() {
        return this.decomp.getHeight();
    }

    public JpegImage rotate(int angle) {
        if (angle % 90 != 0 || angle < 0 || angle > 270) {
            throw new IllegalArgumentException("Degree must be 90, 180 or 270");
        }
        switch (angle) {
            case 90: {
                this.transformOptions.op = 5;
                break;
            }
            case 180: {
                this.transformOptions.op = 6;
                break;
            }
            case 270: {
                this.transformOptions.op = 7;
                break;
            }
        }
        return this;
    }

    public JpegImage flipHorizontal() {
        this.transformOptions.op = 1;
        return this;
    }

    public JpegImage flipVertical() {
        this.transformOptions.op = 2;
        return this;
    }

    public JpegImage transpose() {
        this.transformOptions.op = 3;
        return this;
    }

    public JpegImage transverse() {
        this.transformOptions.op = 4;
        return this;
    }

    public JpegImage downScale(int width, int height) throws TJException {
        return this.downScale(width, height, 75);
    }

    public JpegImage downScale(int width, int height, int quality) throws TJException {
        if (this.transformOptions.op != 0 || !this.transformOptions.isEmpty()) {
            this.transform();
            this.setTransformOptions(new TJTransform());
        }
        if (width > this.getWidth() || height > this.getHeight()) {
            throw new IllegalArgumentException(String.format("Target dimensions must be smaller than original dimensions, were %sx%s vs %sx%s.", this.getWidth(), this.getHeight(), width, height));
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height must be greater than 0");
        }
        this.setImageData(EpegScaler.downScaleJpegImage((byte[])this.imgData, (int)width, (int)height, (int)quality));
        return this;
    }

    public JpegImage crop(int x, int y, int width, int height) {
        if (width > this.getWidth() - x || height > this.getHeight() - y) {
            throw new IllegalArgumentException("Width or height exceed the boundaries of the cropped image, check the vertical/horizontal offset!");
        }
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException("Vertical and horizontal offsets cannot be negative.");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height must be greater than 0");
        }
        this.transformOptions.setBounds(x, y, width, height);
        this.transformOptions.options |= 4;
        return this;
    }

    public JpegImage toGrayscale() {
        this.transformOptions.options |= 8;
        return this;
    }

    public JpegImage transform() throws TJException {
        TJTransformer transformer = new TJTransformer(this.imgData);
        int destinationSize = TJ.bufSize((int)this.getWidth(), (int)this.getHeight(), (int)this.decomp.getSubsamp());
        byte[][] destBufs = new byte[1][destinationSize];
        transformer.transform(destBufs, new TJTransform[]{this.transformOptions}, 0);
        int[] transformedSizes = transformer.getTransformedSizes();
        this.setImageData(Arrays.copyOfRange(destBufs[0], 0, transformedSizes[0]));
        this.transformOptions = new TJTransform();
        return this;
    }

    public byte[] toByteArray() {
        return this.imgData;
    }

    public void write(URI filePath) throws IOException {
        File outFile = new File(filePath.toURL().getFile());
        if (!outFile.exists()) {
            outFile.createNewFile();
        }
        IOUtils.write((byte[])this.imgData, (OutputStream)new FileOutputStream(outFile));
    }
}

