/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.image.backend.impl.repository.imageio.v2;

import de.digitalcollections.iiif.hymir.image.backend.impl.repository.imageio.v2.JAIImage;
import de.digitalcollections.iiif.hymir.image.model.api.enums.ImageBitDepth;
import de.digitalcollections.iiif.hymir.image.model.api.enums.ImageFormat;
import de.digitalcollections.iiif.hymir.image.model.api.v2.RegionParameters;
import de.digitalcollections.iiif.hymir.image.model.api.v2.ResizeParameters;
import de.digitalcollections.iiif.hymir.image.model.api.v2.TransformationException;
import de.digitalcollections.iiif.hymir.model.api.exception.InvalidParametersException;
import de.digitalcollections.iiif.hymir.model.api.exception.UnsupportedFormatException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JAIImage
implements de.digitalcollections.iiif.hymir.image.model.api.v2.Image {
    private static final Logger LOGGER = LoggerFactory.getLogger(JAIImage.class);
    private BufferedImage image;
    private String formatString;

    public JAIImage(BufferedImage image, String format) {
        this.image = image;
        this.formatString = format;
    }

    public JAIImage(byte[] inData) throws IOException, UnsupportedFormatException {
        this((InputStream)new ByteArrayInputStream(inData), null);
    }

    public JAIImage(byte[] inData, RegionParameters region) throws IOException, UnsupportedFormatException {
        this((InputStream)new ByteArrayInputStream(inData), region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAIImage(InputStream imgData, RegionParameters region) throws IOException, UnsupportedFormatException {
        ImageIO.setUseCache(true);
        ImageReader reader = null;
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(imgData);){
            BufferedImage img;
            Iterator<ImageReader> readers = ImageIO.getImageReaders(imageInputStream);
            if (!readers.hasNext()) {
                throw new UnsupportedFormatException("Could not read image, unsupported format?");
            }
            reader = readers.next();
            this.formatString = reader.getFormatName();
            reader.setInput(imageInputStream, true, true);
            ImageReadParam params = reader.getDefaultReadParam();
            if (region != null && region.isAbsolute()) {
                int x = (int)Math.ceil(region.getHorizontalOffset());
                int y = (int)Math.ceil(region.getVerticalOffset());
                int width = (int)Math.ceil(region.getWidth());
                int height = (int)Math.ceil(region.getHeight());
                Rectangle rect = new Rectangle(x, y, width, height);
                params.setSourceRegion(rect);
            }
            this.image = img = reader.read(0, params);
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }

    public static ImageFormat getFormatFromString(String formatName) throws UnsupportedFormatException {
        ImageFormat imageFormat = ImageFormat.getByExtension((String)formatName.toLowerCase());
        if (imageFormat == null) {
            throw new UnsupportedFormatException();
        }
        return imageFormat;
    }

    public de.digitalcollections.iiif.hymir.image.model.api.v2.Image flipHorizontally() {
        BufferedImage flipped = new BufferedImage(this.image.getWidth(), this.image.getHeight(), this.image.getType());
        AffineTransform tran = AffineTransform.getTranslateInstance(this.image.getWidth(), 0.0);
        AffineTransform flip = AffineTransform.getScaleInstance(-1.0, 1.0);
        tran.concatenate(flip);
        Graphics2D g = flipped.createGraphics();
        g.setTransform(tran);
        g.drawImage((Image)this.image, 0, 0, null);
        g.dispose();
        this.image = flipped;
        return this;
    }

    public ImageFormat getFormat() {
        try {
            return JAIImage.getFormatFromString((String)this.formatString);
        }
        catch (UnsupportedFormatException ignored) {
            return null;
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public byte[] toByteArray() throws IOException {
        byte[] output;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)this.image, this.formatString, os);
            output = os.toByteArray();
        }
        return output;
    }

    public de.digitalcollections.iiif.hymir.image.model.api.v2.Image crop(RegionParameters params) throws UnsupportedOperationException, InvalidParametersException {
        int targetHeight;
        int targetWidth;
        int y;
        int x;
        if (params.isAbsolute()) {
            x = (int)Math.ceil(params.getHorizontalOffset());
            y = (int)Math.ceil(params.getVerticalOffset());
            targetWidth = (int)Math.ceil(params.getWidth());
            targetHeight = (int)Math.ceil(params.getHeight());
        } else {
            x = (int)Math.ceil((float)this.image.getWidth() * params.getHorizontalOffset() / 100.0f);
            y = (int)Math.ceil((float)this.image.getHeight() * params.getVerticalOffset() / 100.0f);
            targetWidth = (int)Math.ceil((float)this.image.getWidth() * params.getWidth() / 100.0f);
            targetHeight = (int)Math.ceil((float)this.image.getHeight() * params.getHeight() / 100.0f);
        }
        if (x >= this.getWidth() || y >= this.getHeight()) {
            throw new InvalidParametersException("x and/or y are out of bounds.");
        }
        if (x + targetWidth > this.getWidth()) {
            targetWidth = this.getWidth() - x;
        }
        if (y + targetHeight > this.getHeight()) {
            targetHeight = this.getHeight() - y;
        }
        if (targetHeight != this.image.getHeight() || targetWidth != this.image.getWidth()) {
            BufferedImage dest;
            this.image = dest = this.image.getSubimage(x, y, targetWidth, targetHeight);
        }
        return this;
    }

    public de.digitalcollections.iiif.hymir.image.model.api.v2.Image scale(ResizeParameters params) throws UnsupportedOperationException, InvalidParametersException {
        int oldWidth = this.getWidth();
        int oldHeight = this.getHeight();
        int newWidth = (int)Math.ceil(params.getWidth());
        int newHeight = (int)Math.ceil(params.getHeight());
        if (oldWidth == newWidth && oldHeight == newHeight) {
            return this;
        }
        this.image = Scalr.resize((BufferedImage)this.image, (Scalr.Method)Scalr.Method.AUTOMATIC, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)newWidth, (int)newHeight, (BufferedImageOp[])new BufferedImageOp[0]);
        return this;
    }

    public de.digitalcollections.iiif.hymir.image.model.api.v2.Image rotate(int arcDegree) throws UnsupportedOperationException, InvalidParametersException {
        Scalr.Rotation rotation;
        if (arcDegree % 90 > 0) {
            throw new UnsupportedOperationException("Can only rotate by multiples of 90 degrees.");
        }
        switch (arcDegree) {
            case -90: 
            case 270: {
                rotation = Scalr.Rotation.CW_270;
                break;
            }
            case 90: {
                rotation = Scalr.Rotation.CW_90;
                break;
            }
            case 180: {
                rotation = Scalr.Rotation.CW_180;
                break;
            }
            default: {
                return this;
            }
        }
        this.image = Scalr.rotate((BufferedImage)this.image, (Scalr.Rotation)rotation, (BufferedImageOp[])new BufferedImageOp[0]);
        return this;
    }

    public de.digitalcollections.iiif.hymir.image.model.api.v2.Image toDepth(ImageBitDepth depth) throws UnsupportedOperationException {
        int newColorType = this.image.getType();
        if (null != depth) {
            switch (1.$SwitchMap$de$digitalcollections$iiif$hymir$image$model$api$enums$ImageBitDepth[depth.ordinal()]) {
                case 1: {
                    newColorType = 10;
                    break;
                }
                case 2: {
                    newColorType = 12;
                    break;
                }
                case 3: {
                    newColorType = 5;
                    break;
                }
            }
        }
        BufferedImage newImage = new BufferedImage(this.image.getWidth(), this.image.getHeight(), newColorType);
        Graphics2D g2d = newImage.createGraphics();
        g2d.drawImage((Image)this.image, 0, 0, null);
        this.image = newImage;
        return this;
    }

    public de.digitalcollections.iiif.hymir.image.model.api.v2.Image convert(ImageFormat targetFormat) throws UnsupportedOperationException, TransformationException {
        ImageFormat sourceFormat = this.getFormat();
        if (sourceFormat != targetFormat) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)this.image, targetFormat.name().toLowerCase(), os);
                ByteArrayInputStream fis = new ByteArrayInputStream(os.toByteArray());
                this.image = ImageIO.read(fis);
                this.formatString = targetFormat.name();
            }
            catch (IOException ex) {
                LOGGER.error("Could not read converted image", (Throwable)ex);
                throw new TransformationException("Could not convert image", (Throwable)ex);
            }
        }
        return this;
    }

    public void performTransformation() {
    }
}

