/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.frontend.impl.springmvc.controller;

import de.digitalcollections.commons.server.HttpLoggingUtilities;
import de.digitalcollections.iiif.presentation.business.api.v2.PresentationService;
import de.digitalcollections.iiif.presentation.model.api.exceptions.InvalidDataException;
import de.digitalcollections.iiif.presentation.model.api.exceptions.NotFoundException;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ViewController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewController.class);
    @Autowired
    private PresentationService presentationService;

    @RequestMapping(value={"", "/"}, method={RequestMethod.GET})
    public String viewHomepage(Model model) {
        model.addAttribute("menu", (Object)"home");
        return "index";
    }

    @RequestMapping(value={"/image/{identifier}/view.html"}, method={RequestMethod.GET})
    public String viewImageGet(@PathVariable String identifier, Model model) {
        model.addAttribute("infoUrl", (Object)("/image/v2/" + identifier + "/info.json"));
        return "openseadragon/view";
    }

    @RequestMapping(value={"/image/view"}, method={RequestMethod.POST})
    public String viewImagePost(@RequestParam String identifier) {
        return "redirect:/image/" + identifier + "/view.html";
    }

    @RequestMapping(value={"/presentation/{identifier}/view.html"}, method={RequestMethod.GET})
    public String viewPresentationGet(@PathVariable String identifier, Model model) {
        model.addAttribute("presentationUri", (Object)("/presentation/v2/" + identifier));
        return "mirador/view";
    }

    @RequestMapping(value={"/presentation/view"}, method={RequestMethod.POST})
    public String viewPresentationPost(@RequestParam String identifier, Model model) {
        return "redirect:/presentation/" + identifier + "/view.html";
    }

    @RequestMapping(value={"/presentation/manifest"}, method={RequestMethod.GET})
    public String viewPresentationManifest(@RequestParam String identifier) {
        return "forward:/presentation/v2/" + identifier + "/manifest";
    }

    @RequestMapping(value={"/presentation/collection"}, method={RequestMethod.GET})
    public String viewPresentationCollection(@RequestParam String name) {
        return "forward:/presentation/v2/collection/" + name;
    }

    @RequestMapping(value={"/presentation/{version}/{objectIdentifier}/canvas/{canvasName}/view"}, method={RequestMethod.GET})
    public String viewCanvasGet(@PathVariable String version, @PathVariable String objectIdentifier, @PathVariable String canvasName, Model model, HttpServletRequest request) throws NotFoundException, InvalidDataException {
        HttpLoggingUtilities.addRequestClientInfoToMDC((HttpServletRequest)request);
        MDC.put((String)"manifestId", (String)objectIdentifier);
        MDC.put((String)"canvasName", (String)canvasName);
        String url = this.getOriginalUri(request).toString();
        String canvasId = url.substring(0, url.indexOf("/view"));
        String manifestId = url.substring(0, url.indexOf("/canvas")) + "/manifest";
        try {
            this.presentationService.getCanvas(objectIdentifier, canvasId);
            LOGGER.info("Serving Canvas for {}", (Object)canvasId);
            model.addAttribute("manifestId", (Object)manifestId);
            model.addAttribute("canvasId", (Object)canvasId);
        }
        catch (NotFoundException e) {
            LOGGER.info("Did not find canvas for {}", (Object)canvasId);
            throw e;
        }
        catch (InvalidDataException e) {
            LOGGER.error("Bad data for {}", (Object)objectIdentifier);
            throw e;
        }
        finally {
            MDC.clear();
        }
        return "mirador/viewCanvas";
    }

    private URI getOriginalUri(HttpServletRequest request) {
        String requestUrl = request.getRequestURL().toString();
        String incomingScheme = URI.create(requestUrl).getScheme();
        String originalScheme = request.getHeader("X-Forwarded-Proto");
        if (originalScheme != null && !incomingScheme.equals(originalScheme)) {
            return URI.create(requestUrl.replaceFirst("^" + incomingScheme, originalScheme));
        }
        return URI.create(requestUrl);
    }
}

