/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.config;

import com.github.mxab.thymeleaf.extras.dataattribute.dialect.DataAttributeDialect;
import java.util.Locale;
import nz.net.ultraq.thymeleaf.LayoutDialect;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.spring4.SpringTemplateEngine;
import org.thymeleaf.spring4.view.ThymeleafViewResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.ServletContextTemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolver;

@Configuration
@ComponentScan(basePackages={"de.digitalcollections.iiif.hymir.frontend.impl.springmvc.controller"})
@EnableAspectJAutoProxy
@EnableWebMvc
@PropertySource(value={"classpath:de/digitalcollections/iiif/hymir/config/SpringConfigWeb-${spring.profiles.active:PROD}.properties"})
public class SpringConfigWeb
extends WebMvcConfigurerAdapter {
    @Value(value="${cacheTemplates}")
    private boolean cacheTemplates;

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/css/**"}).addResourceLocations(new String[]{"/css/"});
        registry.addResourceHandler(new String[]{"/favicon.ico"}).addResourceLocations(new String[]{"/images/favicon.ico"});
        registry.addResourceHandler(new String[]{"/fonts/**"}).addResourceLocations(new String[]{"/fonts/"});
        registry.addResourceHandler(new String[]{"/html/**"}).addResourceLocations(new String[]{"/html/"});
        registry.addResourceHandler(new String[]{"/img/**"}).addResourceLocations(new String[]{"/img/"});
        registry.addResourceHandler(new String[]{"/images/**"}).addResourceLocations(new String[]{"/images/"});
        registry.addResourceHandler(new String[]{"/js/**"}).addResourceLocations(new String[]{"/js/"});
        registry.addResourceHandler(new String[]{"/vendor/**"}).addResourceLocations(new String[]{"/vendor/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    @Bean
    public TemplateResolver servletContextTemplateResolver() {
        ServletContextTemplateResolver templateResolver = new ServletContextTemplateResolver();
        templateResolver.setPrefix("/WEB-INF/templates/");
        templateResolver.setSuffix(".html");
        templateResolver.setCharacterEncoding("UTF-8");
        templateResolver.setTemplateMode("HTML5");
        templateResolver.setCacheable(this.cacheTemplates);
        templateResolver.setOrder(Integer.valueOf(2));
        return templateResolver;
    }

    @Bean
    public SpringTemplateEngine templateEngine() {
        SpringTemplateEngine templateEngine = new SpringTemplateEngine();
        templateEngine.addTemplateResolver((ITemplateResolver)this.servletContextTemplateResolver());
        templateEngine.addDialect((IDialect)new LayoutDialect());
        templateEngine.addDialect((IDialect)new DataAttributeDialect());
        return templateEngine;
    }

    @Bean
    public ViewResolver viewResolver() {
        ThymeleafViewResolver viewResolver = new ThymeleafViewResolver();
        viewResolver.setTemplateEngine(this.templateEngine());
        viewResolver.setOrder(1);
        viewResolver.setContentType("text/html; charset=UTF-8");
        viewResolver.setCharacterEncoding("UTF-8");
        return viewResolver;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        LocaleChangeInterceptor localeChangeInterceptor = new LocaleChangeInterceptor();
        localeChangeInterceptor.setParamName("language");
        registry.addInterceptor((HandlerInterceptor)localeChangeInterceptor);
    }

    @Bean(name={"localeResolver"})
    public LocaleResolver sessionLocaleResolver() {
        SessionLocaleResolver localeResolver = new SessionLocaleResolver();
        localeResolver.setDefaultLocale(Locale.GERMAN);
        return localeResolver;
    }
}

