/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.hymir.config;

import de.digitalcollections.iiif.hymir.config.SpringConfigBackend;
import de.digitalcollections.iiif.hymir.config.SpringConfigBusiness;
import de.digitalcollections.iiif.hymir.config.SpringConfigWeb;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.env.Environment;

@Configuration
@ComponentScan(basePackages={"de.digitalcollections.iiif.image.config", "de.digitalcollections.iiif.presentation.config"})
@Import(value={SpringConfigBackend.class, SpringConfigBusiness.class, SpringConfigWeb.class})
public class SpringConfig
implements EnvironmentAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringConfig.class);

    @Bean(name={"messageSource"})
    public MessageSource configureMessageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasename("classpath:messages");
        messageSource.setCacheSeconds(5);
        messageSource.setDefaultEncoding("UTF-8");
        return messageSource;
    }

    public void setEnvironment(Environment environment) {
        Object[] activeProfiles = environment.getActiveProfiles();
        String activeProfilesStr = Arrays.toString(activeProfiles);
        LOGGER.info("##### Active Profiles: " + activeProfilesStr);
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("JPEG");
        while (readers.hasNext()) {
            LOGGER.info("##### ImageIO reader: " + readers.next());
        }
        readers = ImageIO.getImageReadersByFormatName("TIFF");
        while (readers.hasNext()) {
            LOGGER.info("##### ImageIO reader: " + readers.next());
        }
    }
}

