/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.presentation.model.impl.v2;

import de.digitalcollections.iiif.presentation.model.api.v2.PropertyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class PropertyValueLocalizedImpl
implements PropertyValue {
    private Map<Locale, List<String>> localizations = new HashMap<Locale, List<String>>();

    public PropertyValueLocalizedImpl() {
    }

    public PropertyValueLocalizedImpl(Locale language, String value) {
        this();
        this.addValue(language, value);
    }

    public void addValue(String language, String value) {
        this.addValue(Locale.forLanguageTag(language), value);
    }

    public void addValue(Locale language, String value) {
        if (!this.localizations.containsKey(language)) {
            this.localizations.put(language, new ArrayList());
        }
        this.localizations.get(language).add(value);
    }

    public Set<Locale> getLocalizations() {
        return this.localizations.keySet();
    }

    public List<String> getValues() {
        List<String> values = this.getValues(Locale.getDefault());
        if (values == null) {
            values = this.localizations.entrySet().iterator().next().getValue();
        }
        return values;
    }

    public List<String> getValues(String language) {
        return this.localizations.get(Locale.forLanguageTag(language));
    }

    public List<String> getValues(Locale locale) {
        return this.localizations.get(locale);
    }
}

