/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.presentation.model.impl.v2;

import de.digitalcollections.iiif.presentation.model.api.v2.Canvas;
import de.digitalcollections.iiif.presentation.model.api.v2.Image;
import de.digitalcollections.iiif.presentation.model.api.v2.Metadata;
import de.digitalcollections.iiif.presentation.model.api.v2.PropertyValue;
import de.digitalcollections.iiif.presentation.model.api.v2.Thumbnail;
import de.digitalcollections.iiif.presentation.model.api.v2.references.IiifReference;
import de.digitalcollections.iiif.presentation.model.impl.v2.AbstractIiifResourceImpl;
import java.net.URI;
import java.util.List;

public class CanvasImpl
extends AbstractIiifResourceImpl
implements Canvas {
    private PropertyValue description;
    private int height;
    private List<Image> images;
    private PropertyValue label;
    private List<Metadata> metadata;
    private List<IiifReference> otherContent;
    private Thumbnail thumbnail;
    private String viewingHint;
    private int width;

    public CanvasImpl() {
        this.height = 0;
        this.label = null;
        this.width = 0;
    }

    public CanvasImpl(URI id, PropertyValue label, int height, int width) {
        assert (id != null);
        assert (label != null);
        assert (height > -1);
        assert (width > -1);
        this.id = id;
        this.height = height;
        this.label = label;
        this.width = width;
        this.type = "sc:Canvas";
    }

    public CanvasImpl(String id, PropertyValue label, int height, int width) {
        this(URI.create(id), label, height, width);
    }

    public CanvasImpl(URI id, PropertyValue label, int height, int width, Thumbnail thumbnail) {
        this(id, label, height, width);
        this.thumbnail = thumbnail;
    }

    public CanvasImpl(String id, PropertyValue label, int height, int width, Thumbnail thumbnail) {
        this(URI.create(id), label, height, width, thumbnail);
    }

    public PropertyValue getDescription() {
        return this.description;
    }

    public void setDescription(PropertyValue description) {
        this.description = description;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public List<Image> getImages() {
        return this.images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public PropertyValue getLabel() {
        return this.label;
    }

    public void setLabel(PropertyValue label) {
        this.label = label;
    }

    public List<Metadata> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<Metadata> metadata) {
        this.metadata = metadata;
    }

    public Thumbnail getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(Thumbnail thumbnail) {
        this.thumbnail = thumbnail;
    }

    public String getViewingHint() {
        return this.viewingHint;
    }

    public void setViewingHint(String viewingHint) {
        this.viewingHint = viewingHint;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public List<IiifReference> getOtherContent() {
        return this.otherContent;
    }

    public void setOtherContent(List<IiifReference> iiifReferences) {
        this.otherContent = iiifReferences;
    }
}

