/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.presentation.model.impl.jackson.deserializer.v2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.digitalcollections.iiif.presentation.model.api.v2.Service;
import de.digitalcollections.iiif.presentation.model.impl.v2.PhysicalDimensionsServiceImpl;
import de.digitalcollections.iiif.presentation.model.impl.v2.ServiceImpl;
import java.io.IOException;

public class ServiceDeserializer
extends JsonDeserializer<Service> {
    private String getAsString(TreeNode parent, String key) {
        TreeNode node = parent.get(key);
        if (node != null) {
            return ((TextNode)node).textValue();
        }
        return null;
    }

    public Service deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        TreeNode node = mapper.readTree(jp);
        String profile = null;
        TreeNode profileObj = node.get("profile");
        if (profileObj != null) {
            profile = ((TextNode)profileObj).textValue();
        }
        if (profile == null) {
            return null;
        }
        if (profile.contains("physdim")) {
            PhysicalDimensionsServiceImpl service = new PhysicalDimensionsServiceImpl();
            service.setContext(this.getAsString(node, "@context"));
            service.setProfile(this.getAsString(node, "profile"));
            service.setPhysicalScale(((DoubleNode)node.get("physicalScale")).asDouble());
            service.setPhysicalUnits(this.getAsString(node, "physicalUnits"));
            return service;
        }
        ServiceImpl service = new ServiceImpl();
        service.setContext(this.getAsString(node, "@context"));
        service.setProfile(this.getAsString(node, "profile"));
        service.setId(this.getAsString(node, "@id"));
        return service;
    }
}

