/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.presentation.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.iiif.presentation.frontend.impl.client.rest.IIIFRepository;
import de.digitalcollections.iiif.presentation.model.impl.jackson.v2_0_0.IiifPresentationApiObjectMapper;
import feign.Feign;
import feign.codec.Decoder;
import feign.jackson.JacksonDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

@Configuration
@PropertySource(value={"classpath:de/digitalcollections/iiif/presentation/config/SpringConfigClientRest-${spring.profiles.active:PROD}.properties"})
public class SpringConfigClientRest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringConfigClientRest.class);
    @Value(value="${presentation.iiifRepositoryURL}")
    private String iiifRepositoryURL;

    @Bean
    public IIIFRepository iiifRepository() {
        LOGGER.info("IIIF Rest Client using Endpoint {}" + this.iiifRepositoryURL);
        IIIFRepository iiif = (IIIFRepository)Feign.builder().decoder((Decoder)new JacksonDecoder((ObjectMapper)new IiifPresentationApiObjectMapper())).target(IIIFRepository.class, this.iiifRepositoryURL);
        return iiif;
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }
}

