/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.presentation.business.impl.service.v2;

import de.digitalcollections.iiif.presentation.backend.api.repository.v2.PresentationRepository;
import de.digitalcollections.iiif.presentation.business.api.PresentationSecurityService;
import de.digitalcollections.iiif.presentation.business.api.v2.PresentationService;
import de.digitalcollections.iiif.presentation.model.api.exceptions.InvalidDataException;
import de.digitalcollections.iiif.presentation.model.api.exceptions.NotFoundException;
import de.digitalcollections.iiif.presentation.model.api.v2.Canvas;
import de.digitalcollections.iiif.presentation.model.api.v2.Collection;
import de.digitalcollections.iiif.presentation.model.api.v2.Manifest;
import de.digitalcollections.iiif.presentation.model.api.v2.Range;
import de.digitalcollections.iiif.presentation.model.api.v2.Sequence;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="PresentationServiceImpl-v2.0.0")
public class PresentationServiceImpl
implements PresentationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PresentationServiceImpl.class);
    @Autowired
    private PresentationRepository presentationRepository;
    @Autowired(required=false)
    private PresentationSecurityService presentationSecurityService;

    public Collection getCollection(String name) throws NotFoundException, InvalidDataException {
        try {
            return this.presentationRepository.getCollection(name);
        }
        catch (NotFoundException ex) {
            LOGGER.debug("Collection for '{}' not found.", (Object)name);
            throw new NotFoundException(ex.getMessage());
        }
    }

    public Manifest getManifest(String identifier) throws NotFoundException, InvalidDataException {
        if (this.presentationSecurityService != null && !this.presentationSecurityService.isAccessAllowed(identifier)) {
            LOGGER.info("Access to manifest for object '{}' is not allowed!", (Object)identifier);
            throw new NotFoundException();
        }
        LOGGER.debug("Access to manifest for object '{}' is allowed.", (Object)identifier);
        try {
            return this.presentationRepository.getManifest(identifier);
        }
        catch (NotFoundException ex) {
            LOGGER.debug("Manifest for '{}' not found.", (Object)identifier);
            throw new NotFoundException(ex.getMessage());
        }
    }

    public Canvas getCanvas(String manifestId, URI canvasUri) throws NotFoundException, InvalidDataException {
        Manifest manifest = this.getManifest(manifestId);
        return manifest.getSequences().stream().flatMap(seq -> seq.getCanvases().stream()).filter(canv -> canv.getId().equals(canvasUri)).findFirst().orElseThrow(NotFoundException::new);
    }

    public Range getRange(String manifestId, URI rangeUri) throws NotFoundException, InvalidDataException {
        Manifest manifest = this.getManifest(manifestId);
        return manifest.getStructures().stream().filter(range -> range.getId().equals(rangeUri)).findFirst().orElseThrow(NotFoundException::new);
    }

    public Sequence getSequence(String manifestId, URI sequenceUri) throws NotFoundException, InvalidDataException {
        Manifest manifest = this.getManifest(manifestId);
        return manifest.getSequences().stream().filter(seq -> seq.getId().equals(sequenceUri)).findFirst().orElseThrow(NotFoundException::new);
    }
}

