/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.presentation.business.impl.service.v2_0_0;

import de.digitalcollections.iiif.presentation.backend.api.repository.v2_0_0.PresentationRepository;
import de.digitalcollections.iiif.presentation.business.api.PresentationSecurityService;
import de.digitalcollections.iiif.presentation.business.api.exceptions.NotFoundException;
import de.digitalcollections.iiif.presentation.business.api.v2_0_0.PresentationService;
import de.digitalcollections.iiif.presentation.model.api.v2_0_0.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="PresentationServiceImpl-v2.0.0")
public class PresentationServiceImpl
implements PresentationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PresentationServiceImpl.class);
    @Autowired
    private PresentationRepository presentationRepository;
    @Autowired(required=false)
    private PresentationSecurityService presentationSecurityService;

    public Manifest getManifest(String identifier) throws NotFoundException {
        if (this.presentationSecurityService != null && !this.presentationSecurityService.isAccessAllowed(identifier)) {
            LOGGER.info("Access to manifest for object '{}' is not allowed!", (Object)identifier);
            throw new NotFoundException();
        }
        LOGGER.info("Access to manifest for object '{}' is allowed.", (Object)identifier);
        try {
            return this.presentationRepository.getManifest(identifier);
        }
        catch (de.digitalcollections.iiif.presentation.backend.api.exceptions.NotFoundException ex) {
            LOGGER.info("Manifest for '{}' not found.", (Object)identifier);
            throw new NotFoundException(ex.getMessage());
        }
    }
}

