/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.presentation.backend.impl.repository.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import de.digitalcollections.core.business.api.ResourceService;
import de.digitalcollections.core.model.api.MimeType;
import de.digitalcollections.core.model.api.resource.Resource;
import de.digitalcollections.core.model.api.resource.enums.ResourcePersistenceType;
import de.digitalcollections.core.model.api.resource.exceptions.ResourceIOException;
import de.digitalcollections.iiif.presentation.backend.api.exceptions.NotFoundException;
import de.digitalcollections.iiif.presentation.backend.api.repository.v2.PresentationRepository;
import de.digitalcollections.iiif.presentation.model.api.v2.Manifest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="PresentationRepositoryImpl-v2.0.0")
public class PresentationRepositoryImpl
implements PresentationRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(PresentationRepositoryImpl.class);
    private final Cache<String, Manifest> httpCache = CacheBuilder.newBuilder().maximumSize(32L).build();
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ResourceService resourceService;

    public Manifest getManifest(String identifier) throws NotFoundException {
        Resource resource;
        try {
            resource = this.resourceService.get(identifier, ResourcePersistenceType.REFERENCED, MimeType.MIME_APPLICATION_JSON);
        }
        catch (ResourceIOException ex) {
            LOGGER.warn("Error getting manifest for identifier " + identifier);
            throw new NotFoundException("No manifest for identifier " + identifier);
        }
        URI uri = resource.getUri();
        return this.getManifest(uri);
    }

    public Manifest getManifest(URI manifestUri) throws NotFoundException {
        String location = manifestUri.toString();
        LOGGER.info("Trying to get manifest from " + location);
        try {
            String cacheKey;
            Manifest manifest;
            String scheme = manifestUri.getScheme();
            if ("http".equals(scheme) && (manifest = (Manifest)this.httpCache.getIfPresent((Object)(cacheKey = location))) != null) {
                LOGGER.debug("HTTP Cache hit for manifest " + cacheKey);
                return manifest;
            }
            String manifestJson = this.getManifestJson(manifestUri);
            manifest = (Manifest)this.objectMapper.readValue(manifestJson, Manifest.class);
            if ("http".equals(scheme)) {
                String cacheKey2 = location;
                this.httpCache.put((Object)cacheKey2, (Object)manifest);
            }
            return manifest;
        }
        catch (IOException ex) {
            LOGGER.warn("Error getting manifest from location " + location, (Throwable)ex);
            throw new NotFoundException("No manifest for location: " + location);
        }
    }

    public String getManifestJson(URI manifestUri) throws NotFoundException {
        try {
            InputStream inputStream = this.resourceService.getInputStream(manifestUri);
            String json = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            LOGGER.debug("DONE getManifestJson() for " + manifestUri.toString());
            return json;
        }
        catch (IOException e) {
            throw new NotFoundException((Throwable)e);
        }
    }

    public JSONObject getManifestAsJsonObject(URI manifestUri) throws NotFoundException, ParseException {
        String json = this.getManifestJson(manifestUri);
        JSONParser parser = new JSONParser();
        Object obj = parser.parse(json);
        JSONObject jsonObject = (JSONObject)obj;
        return jsonObject;
    }

    public JSONObject getManifestAsJsonObject(String manifestUri) throws URISyntaxException, NotFoundException, ParseException {
        return this.getManifestAsJsonObject(new URI(manifestUri));
    }
}

