/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.image.model.impl.v2;

import de.digitalcollections.iiif.image.model.api.exception.InvalidParametersException;
import de.digitalcollections.iiif.image.model.api.v2.RegionParameters;

public class RegionParametersImpl
implements RegionParameters {
    private boolean absolute;
    private float height;
    private float horizontalOffset;
    private float verticalOffset;
    private float width;

    public RegionParametersImpl() {
    }

    public RegionParametersImpl(boolean absolute, float horizontalOffset, float verticalOffset, float width, float height) {
        this.absolute = absolute;
        this.horizontalOffset = horizontalOffset;
        this.verticalOffset = verticalOffset;
        this.width = width;
        this.height = height;
    }

    public void makeAbsolute(int imageWidth, int imageHeight) throws InvalidParametersException {
        this.horizontalOffset = this.getHorizontalOffset() * (float)imageWidth;
        this.verticalOffset = this.getVerticalOffset() * (float)imageHeight;
        this.width = this.getWidth() * (float)imageWidth;
        this.height = this.getHeight() * (float)imageHeight;
        if (this.width > (float)imageWidth - this.horizontalOffset) {
            this.width = (float)imageWidth - this.horizontalOffset;
        }
        if (this.height > (float)imageHeight - this.verticalOffset) {
            this.height = (float)imageHeight - this.verticalOffset;
        }
        if (this.getHorizontalOffset() > (float)imageWidth || this.getVerticalOffset() > (float)imageHeight) {
            throw new InvalidParametersException("Either vertical or horizontal offset are outside of the image.");
        }
        this.absolute = true;
    }

    public float getHeight() {
        return this.height;
    }

    public float getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public float getVerticalOffset() {
        return this.verticalOffset;
    }

    public float getWidth() {
        return this.width;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setHorizontalOffset(float horizontalOffset) {
        this.horizontalOffset = horizontalOffset;
    }

    public void setVerticalOffset(float verticalOffset) {
        this.verticalOffset = verticalOffset;
    }

    public void setWidth(float width) {
        this.width = width;
    }
}

