/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.image.model.impl.v2_0_0;

import de.digitalcollections.iiif.image.model.api.exception.InvalidParametersException;
import de.digitalcollections.iiif.image.model.api.v2_0_0.ResizeParameters;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ResizeParametersImpl
implements ResizeParameters {
    private int height;
    private int maxHeight;
    private int maxWidth;
    private int scaleFactor;
    private int width;

    public ResizeParametersImpl() {
    }

    public ResizeParametersImpl(ResizeParameters sizeParameters, float currentWidth, float currentHeight) throws InvalidParametersException {
        float calculatedHeight;
        float calculatedWidth;
        float aspect = currentWidth / currentHeight;
        int targetHeight = sizeParameters.getHeight();
        int targetWidth = sizeParameters.getWidth();
        int targetMaxHeight = sizeParameters.getMaxHeight();
        int targetMaxWidth = sizeParameters.getMaxWidth();
        this.scaleFactor = sizeParameters.getScaleFactor();
        if (targetWidth > 0 && targetHeight == 0 && targetMaxHeight == 0 && targetMaxWidth == 0) {
            calculatedWidth = targetWidth;
            calculatedHeight = calculatedWidth / aspect;
        } else if (targetWidth == 0 && targetHeight > 0 && targetMaxHeight == 0 && targetMaxWidth == 0) {
            calculatedHeight = targetHeight;
            calculatedWidth = aspect * calculatedHeight;
        } else if (targetWidth > 0 && targetHeight > 0 && targetMaxHeight == 0 && targetMaxWidth == 0) {
            calculatedHeight = targetHeight;
            calculatedWidth = targetWidth;
        } else if (targetWidth == 0 && targetHeight == 0 && targetMaxHeight == 0 && targetMaxWidth == 0 && this.scaleFactor > 0) {
            float factor = (float)this.scaleFactor / 100.0f;
            calculatedHeight = factor * currentHeight;
            calculatedWidth = factor * currentWidth;
        } else if (targetMaxHeight > 0 && targetMaxWidth > 0) {
            if ((float)targetMaxHeight > currentHeight && (float)targetMaxWidth > currentWidth) {
                calculatedHeight = -1.0f;
                calculatedWidth = -1.0f;
            } else if ((float)targetMaxHeight < currentHeight && (float)targetMaxWidth > currentWidth) {
                float factor = (float)targetMaxHeight / currentHeight;
                calculatedHeight = factor * currentHeight;
                calculatedWidth = factor * currentWidth;
            } else if ((float)targetMaxHeight > currentHeight && (float)targetMaxWidth < currentWidth) {
                float factor = (float)targetMaxWidth / currentWidth;
                calculatedHeight = factor * currentHeight;
                calculatedWidth = factor * currentWidth;
            } else {
                float factorHeight = (float)targetMaxHeight / currentHeight;
                float factorWidth = (float)targetMaxWidth / currentWidth;
                float factor = Math.min(factorHeight, factorWidth);
                calculatedHeight = factor * currentHeight;
                calculatedWidth = factor * currentWidth;
            }
        } else {
            throw new InvalidParametersException("Parameter set is invalid.");
        }
        this.width = (int)Math.ceil(calculatedWidth);
        this.height = (int)Math.ceil(calculatedHeight);
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int targetHeight) {
        this.height = targetHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setScaleFactor(int scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public void setWidth(int targetWidth) {
        this.width = targetWidth;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).toString();
    }
}

