/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.image.model.impl.v2_0_0;

import de.digitalcollections.iiif.image.model.api.exception.InvalidParametersException;
import de.digitalcollections.iiif.image.model.api.v2_0_0.RegionParameters;

public class RegionParametersImpl
implements RegionParameters {
    private boolean absolute;
    private float height;
    private float horizontalOffset;
    private float verticalOffset;
    private float width;

    public RegionParametersImpl() {
    }

    public RegionParametersImpl(boolean absolute, float horizontalOffset, float verticalOffset, float width, float height) {
        this.absolute = absolute;
        this.horizontalOffset = horizontalOffset;
        this.verticalOffset = verticalOffset;
        this.width = width;
        this.height = height;
    }

    public RegionParametersImpl(RegionParametersImpl regionParameters, int origWidth, int origHeight) throws InvalidParametersException {
        assert (regionParameters != null);
        assert (!regionParameters.isAbsolute());
        if (regionParameters.getHorizontalOffset() > (float)origWidth || regionParameters.getVerticalOffset() > (float)origHeight) {
            throw new InvalidParametersException("Either vertical or horizontal offset are outside of the image.");
        }
        this.horizontalOffset = regionParameters.getHorizontalOffset() * (float)origWidth;
        this.verticalOffset = regionParameters.getVerticalOffset() * (float)origHeight;
        this.width *= (float)origWidth;
        this.height *= (float)origHeight;
        if (this.width > (float)origWidth - this.horizontalOffset) {
            this.width = (float)origWidth - this.horizontalOffset;
        }
        if (this.height > (float)origHeight - this.verticalOffset) {
            this.height = (float)origHeight - this.verticalOffset;
        }
    }

    public float getHeight() {
        return this.height;
    }

    public float getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public float getVerticalOffset() {
        return this.verticalOffset;
    }

    public float getWidth() {
        return this.width;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setHorizontalOffset(float horizontalOffset) {
        this.horizontalOffset = horizontalOffset;
    }

    public void setVerticalOffset(float verticalOffset) {
        this.verticalOffset = verticalOffset;
    }

    public void setWidth(float width) {
        this.width = width;
    }
}

