/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.image.frontend.impl.springmvc.controller.v2;

import de.digitalcollections.iiif.image.business.api.service.v2.IiifParameterParserService;
import de.digitalcollections.iiif.image.business.api.service.v2.ImageService;
import de.digitalcollections.iiif.image.frontend.impl.springmvc.exception.ResolvingException;
import de.digitalcollections.iiif.image.frontend.impl.springmvc.exception.ResourceNotFoundException;
import de.digitalcollections.iiif.image.frontend.impl.springmvc.exception.TransformationException;
import de.digitalcollections.iiif.image.frontend.impl.springmvc.exception.UnsupportedFormatException;
import de.digitalcollections.iiif.image.model.api.enums.ImageBitDepth;
import de.digitalcollections.iiif.image.model.api.enums.ImageFormat;
import de.digitalcollections.iiif.image.model.api.exception.InvalidParametersException;
import de.digitalcollections.iiif.image.model.api.v2.Image;
import de.digitalcollections.iiif.image.model.api.v2.ImageInfo;
import de.digitalcollections.iiif.image.model.api.v2.RegionParameters;
import de.digitalcollections.iiif.image.model.api.v2.ResizeParameters;
import de.digitalcollections.iiif.image.model.api.v2.RotationParameters;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.stream.IntStream;
import javax.servlet.http.HttpServletRequest;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller(value="IIIFImageApiController-v2")
@RequestMapping(value={"/image/v2/"})
public class IIIFImageApiController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IIIFImageApiController.class);
    public static final String VERSION = "v2";
    @Autowired
    private IiifParameterParserService iiifParameterParserService;
    @Autowired
    private ImageService imageService;
    private final String IIIF_COMPLIANCE = "http://iiif.io/api/image/2/level2.json";
    private final String IIIF_CONTEXT = "http://iiif.io/api/image/2/context.json";

    private String getBasePath(HttpServletRequest request, String identifier) {
        String requestURI = request.getRequestURI();
        if (requestURI.isEmpty()) {
            requestURI = "/" + identifier + "/";
        }
        String idEndpoint = requestURI.substring(0, requestURI.lastIndexOf(47));
        String baseUrl = request.getServerPort() != 80 ? String.format("%s://%s:%d%s", request.getScheme(), request.getServerName(), request.getServerPort(), idEndpoint) : String.format("%s://%s%s", request.getScheme(), request.getServerName(), idEndpoint);
        return baseUrl;
    }

    @CrossOrigin(allowedHeaders={"*"}, origins={"*"})
    @RequestMapping(value={"{identifier}/{region}/{size}/{rotation}/{quality}.{format}"})
    public ResponseEntity<byte[]> getImageRepresentation(@PathVariable String identifier, @PathVariable String region, @PathVariable String size, @PathVariable String rotation, @PathVariable String quality, @PathVariable String format, HttpServletRequest request) throws ResolvingException, UnsupportedFormatException, UnsupportedOperationException, IOException, URISyntaxException, de.digitalcollections.iiif.image.frontend.impl.springmvc.exception.InvalidParametersException, TransformationException {
        String requestURI = request.getRequestURI();
        LOGGER.info("getImageRepresentation for url {}", (Object)requestURI);
        HttpHeaders headers = new HttpHeaders();
        try {
            RegionParameters regionParameters = this.iiifParameterParserService.parseIiifRegion(region);
            ResizeParameters sizeParameters = this.iiifParameterParserService.parseIiifSize(size);
            RotationParameters rotationParameters = this.iiifParameterParserService.parseIiifRotation(rotation);
            ImageBitDepth bitDepthParameter = this.iiifParameterParserService.parseIiifQuality(quality);
            ImageFormat formatParameter = this.iiifParameterParserService.parseIiifFormat(format);
            Image image = this.imageService.processImage(identifier, regionParameters, sizeParameters, rotationParameters, bitDepthParameter, formatParameter);
            ImageFormat imageFormat = image.getFormat();
            String mimeType = imageFormat.getMimeType();
            headers.setContentType(MediaType.parseMediaType((String)mimeType));
            String path = request.getPathInfo() != null ? request.getPathInfo() : request.getServletPath();
            String filename = path.replaceFirst("/image/", "").replace('/', '_').replace(',', '_');
            headers.set("Content-Disposition", "attachment; filename=" + filename);
            byte[] data = image.toByteArray();
            ResponseEntity responseEntity = new ResponseEntity((Object)data, (MultiValueMap)headers, HttpStatus.OK);
            return responseEntity;
        }
        catch (InvalidParametersException ex) {
            throw new de.digitalcollections.iiif.image.frontend.impl.springmvc.exception.InvalidParametersException(ex.getMessage());
        }
        catch (de.digitalcollections.iiif.image.model.api.exception.UnsupportedFormatException ex) {
            throw new UnsupportedFormatException(ex.getMessage());
        }
        catch (de.digitalcollections.iiif.image.model.api.v2.TransformationException ex) {
            throw new TransformationException(ex.getMessage());
        }
    }

    @CrossOrigin(allowedHeaders={"*"}, origins={"*"})
    @RequestMapping(value={"{identifier}/info.json"}, method={RequestMethod.GET})
    public ResponseEntity<String> getInfo(@PathVariable String identifier, HttpServletRequest request) throws ResolvingException, UnsupportedFormatException, UnsupportedOperationException, IOException {
        try {
            identifier = URLDecoder.decode(identifier, "UTF-8");
            String baseUrl = this.getBasePath(request, identifier);
            ImageInfo img = this.imageService.getImageInfo(identifier);
            if (img == null) {
                throw new ResourceNotFoundException();
            }
            JSONObject info = new JSONObject();
            JSONArray profiles = new JSONArray();
            profiles.add((Object)"http://iiif.io/api/image/2/level2.json");
            info.put((Object)"@context", (Object)"http://iiif.io/api/image/2/context.json");
            info.put((Object)"@id", (Object)baseUrl);
            info.put((Object)"width", (Object)img.getWidth());
            info.put((Object)"height", (Object)img.getHeight());
            info.put((Object)"profile", (Object)profiles);
            info.put((Object)"protocol", (Object)"http://iiif.io/api/image");
            JSONArray scaleFactors = new JSONArray();
            Collections.addAll(scaleFactors, new Integer[]{1, 2, 4, 8, 16, 32});
            JSONArray tiles = new JSONArray();
            IntStream.of(128, 256, 512).mapToObj(size -> {
                JSONObject tile = new JSONObject();
                tile.put((Object)"width", (Object)size);
                tile.put((Object)"height", (Object)size);
                tile.put((Object)"scaleFactors", (Object)scaleFactors);
                return tile;
            }).forEach(arg_0 -> tiles.add(arg_0));
            info.put((Object)"tiles", (Object)tiles);
            HttpHeaders headers = new HttpHeaders();
            String contentType = request.getHeader("Accept");
            if (contentType != null && contentType.equals("application/ld+json")) {
                headers.set("Content-Type", contentType);
            } else {
                headers.set("Content-Type", "application/json");
                headers.set("Link", "<http://iiif.io/api/image/2/context.json>; rel=\"http://www.w3.org/ns/json-ld#context\"; type=\"application/ld+json\"");
            }
            String json = info.toJSONString();
            return new ResponseEntity((Object)json, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (de.digitalcollections.iiif.image.model.api.exception.UnsupportedFormatException ex) {
            throw new UnsupportedFormatException(ex.getMessage());
        }
    }

    @CrossOrigin(allowedHeaders={"*"}, origins={"*"})
    @RequestMapping(value={"{identifier}"}, method={RequestMethod.GET})
    public String getInfoRedirect(@PathVariable String identifier) {
        return "redirect:/image/v2/" + identifier + "/info.json";
    }
}

