/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.iiif.image.business.impl.service.v2;

import de.digitalcollections.iiif.image.backend.api.repository.v2.ImageRepository;
import de.digitalcollections.iiif.image.business.api.service.ImageSecurityService;
import de.digitalcollections.iiif.image.business.api.service.v2.ImageService;
import de.digitalcollections.iiif.image.model.api.enums.ImageBitDepth;
import de.digitalcollections.iiif.image.model.api.enums.ImageFormat;
import de.digitalcollections.iiif.image.model.api.exception.InvalidParametersException;
import de.digitalcollections.iiif.image.model.api.exception.ResourceNotFoundException;
import de.digitalcollections.iiif.image.model.api.exception.UnsupportedFormatException;
import de.digitalcollections.iiif.image.model.api.v2.Image;
import de.digitalcollections.iiif.image.model.api.v2.ImageInfo;
import de.digitalcollections.iiif.image.model.api.v2.RegionParameters;
import de.digitalcollections.iiif.image.model.api.v2.ResizeParameters;
import de.digitalcollections.iiif.image.model.api.v2.RotationParameters;
import de.digitalcollections.iiif.image.model.api.v2.TransformationException;
import de.digitalcollections.iiif.image.model.impl.v2.ResizeParametersImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ImageServiceImpl-v2.0.0")
public class ImageServiceImpl
implements ImageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageServiceImpl.class);
    @Autowired
    private List<ImageRepository> imageRepositories;
    @Autowired(required=false)
    private ImageSecurityService imageSecurityService;

    public ImageInfo getImageInfo(String identifier) throws UnsupportedFormatException, UnsupportedOperationException {
        if (this.imageSecurityService != null && !this.imageSecurityService.isAccessAllowed(identifier)) {
            throw new ResourceNotFoundException();
        }
        for (ImageRepository repo : this.imageRepositories) {
            try {
                ImageInfo info = repo.getImageInfo(identifier);
                LOGGER.debug("Using " + repo.getClass().getName());
                return info;
            }
            catch (Throwable throwable) {
            }
        }
        throw new UnsupportedFormatException();
    }

    private Image getImage(String identifier, RegionParameters regionParameters, ImageFormat outputFormat, ImageBitDepth bitDepthParameter) throws UnsupportedFormatException, InvalidParametersException, UnsupportedOperationException {
        for (ImageRepository repo : this.imageRepositories) {
            if (!repo.getSupportedOutputFormats().contains(outputFormat) || bitDepthParameter != null && !repo.getSupportedBitDepths().contains(bitDepthParameter)) continue;
            try {
                Image image = repo.getImage(identifier, regionParameters);
                LOGGER.debug("Using " + repo.getClass().getName());
                return image;
            }
            catch (InvalidParametersException e) {
                throw e;
            }
            catch (Throwable throwable) {
            }
        }
        throw new UnsupportedFormatException();
    }

    public Image processImage(String identifier, RegionParameters regionParameters, ResizeParameters sizeParameters, RotationParameters rotationParameters, ImageBitDepth bitDepthParameter, ImageFormat formatParameter) throws InvalidParametersException, UnsupportedOperationException, UnsupportedFormatException, TransformationException {
        if (this.imageSecurityService != null && !this.imageSecurityService.isAccessAllowed(identifier)) {
            LOGGER.info("Access to image '{}' is not allowed!", (Object)identifier);
            throw new ResourceNotFoundException();
        }
        Image image = this.getImage(identifier, regionParameters, formatParameter, bitDepthParameter);
        if (image == null) {
            throw new ResourceNotFoundException();
        }
        image = this.transformImage(image, regionParameters, sizeParameters, rotationParameters, bitDepthParameter, formatParameter);
        return image;
    }

    private Image transformImage(Image image, RegionParameters regionParameters, ResizeParameters sizeParameters, RotationParameters rotationParameters, ImageBitDepth bitDepthParameter, ImageFormat formatParameter) throws InvalidParametersException, UnsupportedOperationException, UnsupportedFormatException, TransformationException {
        if (regionParameters != null && ((float)image.getWidth() != regionParameters.getWidth() || (float)image.getHeight() != regionParameters.getHeight())) {
            image = image.crop(regionParameters);
        }
        if (sizeParameters != null) {
            sizeParameters = new ResizeParametersImpl(sizeParameters, (float)image.getWidth(), (float)image.getHeight());
        }
        if (sizeParameters != null && sizeParameters.getMaxHeight() != -1 && sizeParameters.getMaxWidth() != -1) {
            image = image.scale(sizeParameters);
        }
        if (rotationParameters != null) {
            if (rotationParameters.isMirrorHorizontally()) {
                image = image.flipHorizontally();
            }
            if (rotationParameters.getDegrees() > 0) {
                image = image.rotate(rotationParameters.getDegrees());
            }
        }
        if (bitDepthParameter != null) {
            image = image.toDepth(bitDepthParameter);
        }
        if (formatParameter != image.getFormat()) {
            image = image.convert(formatParameter);
        }
        image.performTransformation();
        return image;
    }
}

