/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.flusswerk.examples.plain.job;

import de.digitalcollections.flusswerk.engine.Engine;
import de.digitalcollections.flusswerk.engine.exceptions.WorkflowSetupException;
import de.digitalcollections.flusswerk.engine.flow.Flow;
import de.digitalcollections.flusswerk.engine.flow.FlowBuilder;
import de.digitalcollections.flusswerk.engine.messagebroker.MessageBroker;
import de.digitalcollections.flusswerk.engine.messagebroker.MessageBrokerBuilder;
import de.digitalcollections.flusswerk.engine.model.DefaultMessage;
import de.digitalcollections.flusswerk.engine.model.FlusswerkMessage;
import de.digitalcollections.flusswerk.engine.model.Message;
import de.digitalcollections.flusswerk.examples.plain.job.UppercaseTransformer;
import java.io.IOException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(Application.class);

    private void run() throws IOException {
        MessageBroker messageBroker = new MessageBrokerBuilder().connectTo("localhost", 5672).username("guest").password("guest").exchange("workflow").deadLetterExchange("workflow.dlx").readFrom(new String[]{"someInputQueue"}).writeTo("someOutputQueue").build();
        Flow flow = new FlowBuilder().read(FlusswerkMessage::getId).transform((Function)new UppercaseTransformer(true)).writeAndSend(DefaultMessage::new).build();
        Engine engine = new Engine(messageBroker, flow);
        messageBroker.send("someInputQueue", (Message)new DefaultMessage("lowercase-text").put("text", "Shibuyara"));
        engine.start();
    }

    public static void main(String[] args) throws IOException, WorkflowSetupException {
        Application application = new Application();
        application.run();
    }
}

