package de.digitalcollections.flusswerk.examples.plain.justsending;

import de.digitalcollections.flusswerk.engine.exceptions.WorkflowSetupException;
import de.digitalcollections.flusswerk.engine.messagebroker.MessageBroker;
import de.digitalcollections.flusswerk.engine.messagebroker.MessageBrokerBuilder;
import de.digitalcollections.flusswerk.engine.model.DefaultMessage;
import java.io.IOException;

/** Example how to use Flusswerk just to send messages. */
public class Application {

  private void run() throws IOException {
    MessageBroker messageBroker =
        new MessageBrokerBuilder().exchange("workflow").writeTo("someOutputQueue").build();

    for (int i = 0; i < 10; i++) {
      messageBroker.send(new DefaultMessage(Integer.toString(i)));
    }
  }

  public static void main(String[] args) throws IOException, WorkflowSetupException {
    Application application = new Application();
    application.run();
  }
}
