/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.flusswerk.examples.spring;

import de.digitalcollections.flusswerk.engine.Engine;
import de.digitalcollections.flusswerk.engine.flow.Flow;
import de.digitalcollections.flusswerk.engine.flow.FlowBuilder;
import de.digitalcollections.flusswerk.engine.messagebroker.MessageBroker;
import de.digitalcollections.flusswerk.engine.messagebroker.MessageBrokerBuilder;
import de.digitalcollections.flusswerk.engine.model.DefaultMessage;
import de.digitalcollections.flusswerk.engine.model.Message;
import de.digitalcollections.flusswerk.examples.spring.StringReader;
import de.digitalcollections.flusswerk.examples.spring.StringWriter;
import de.digitalcollections.flusswerk.examples.spring.UppercaseTransformer;
import java.io.IOException;
import java.util.function.Function;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WorkflowConfig {
    @Bean
    public Function<DefaultMessage, String> reader() {
        return new StringReader();
    }

    @Bean
    public Function<String, String> transformer() {
        return new UppercaseTransformer();
    }

    @Bean
    public Function<String, Message> writer() {
        return new StringWriter();
    }

    @Bean
    public Flow flow() {
        return new FlowBuilder().read(this.reader()).transform(this.transformer()).writeAndSend(this.writer()).build();
    }

    @Bean
    public MessageBroker messageBroker() {
        return new MessageBrokerBuilder().connectTo("localhost", 5672).username("guest").password("guest").exchange("workflow").deadLetterExchange("workflow.dlx").readFrom(new String[]{"someInputQueue"}).writeTo("someOutputQueue").build();
    }

    @Bean
    public Engine engine() throws IOException {
        return new Engine(this.messageBroker(), this.flow());
    }
}

