/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.core.model.api;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class MimeType {
    private static Map<String, MimeType> knownTypes;
    public static final MimeType MIME_WILDCARD;
    public static final MimeType MIME_IMAGE;
    public static final MimeType MIME_APPLICATION_JSON;
    public static final MimeType MIME_APPLICATION_XML;
    public static final MimeType MIME_IMAGE_JPEG;
    public static final MimeType MIME_IMAGE_TIF;
    public static final MimeType MIME_IMAGE_PNG;
    private final Pattern mimePattern = Pattern.compile("^(?<primaryType>[a-z]+?)/(?<subType>[-\\\\.a-z0-9*]+?)(?:\\+(?<suffix>\\w+))?$");
    private String typeName;
    private List<String> extensions;

    public static MimeType fromExtension(String ext) {
        String extension = ext.startsWith(".") ? ext.substring(1) : ext;
        return knownTypes.values().stream().filter(m -> m.getExtensions().contains(extension)).findFirst().orElseGet(() -> null);
    }

    public static MimeType fromFilename(String filename) {
        return MimeType.fromExtension(FilenameUtils.getExtension((String)filename));
    }

    public static MimeType fromURI(URI uri) {
        try {
            return MimeType.fromFilename(Paths.get(uri).toString());
        }
        catch (FileSystemNotFoundException e) {
            return MimeType.fromExtension(FilenameUtils.getExtension((String)uri.toString()));
        }
    }

    public static MimeType fromTypename(String typeName) {
        return knownTypes.get(typeName);
    }

    private MimeType(String typeName) {
        this.typeName = typeName;
        this.extensions = Collections.emptyList();
    }

    private MimeType(String typeName, List<String> extensions) {
        this.typeName = typeName;
        this.extensions = extensions;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    private void setExtensions(List<String> extensions) {
        this.extensions = extensions;
    }

    public String getPrimaryType() {
        Matcher matcher = this.mimePattern.matcher(this.typeName);
        if (matcher.matches()) {
            return matcher.group("primaryType");
        }
        return null;
    }

    public String getSubType() {
        Matcher matcher = this.mimePattern.matcher(this.typeName);
        if (matcher.matches()) {
            return matcher.group("subType");
        }
        return null;
    }

    public String getSuffix() {
        Matcher matcher = this.mimePattern.matcher(this.typeName);
        if (matcher.matches()) {
            return matcher.group("suffix");
        }
        return null;
    }

    public boolean matches(Object obj) {
        if (obj instanceof MimeType) {
            MimeType mime = (MimeType)obj;
            if (mime == MIME_WILDCARD || this == MIME_WILDCARD) {
                return true;
            }
            if ((mime.getSubType().equals("*") || this.getSubType().equals("*")) && this.getPrimaryType().equals(mime.getPrimaryType())) {
                return true;
            }
            return super.equals(obj);
        }
        return false;
    }

    static {
        InputStream mimeStream = MimeType.class.getClassLoader().getResourceAsStream("mime.types");
        BufferedReader mimeReader = new BufferedReader(new InputStreamReader(mimeStream));
        knownTypes = mimeReader.lines().filter(l -> !l.startsWith("#")).map(l -> l.replaceAll("\\t+", "\t").split("\\t")).map(p -> new MimeType(p[0], Arrays.asList(p[1].split(" ")))).collect(Collectors.toMap(MimeType::getTypeName, Function.identity()));
        knownTypes.get("image/jpeg").setExtensions(Arrays.asList("jpg", "jpeg", "jpe"));
        knownTypes.get("image/tiff").setExtensions(Arrays.asList("tif", "tiff"));
        ArrayList<String> xmlExtensions = new ArrayList<String>(knownTypes.get("application/xml").getExtensions());
        xmlExtensions.add("ent");
        knownTypes.get("application/xml").setExtensions(xmlExtensions);
        MIME_WILDCARD = new MimeType("*", Collections.emptyList());
        MIME_IMAGE = new MimeType("image/*", Collections.emptyList());
        MIME_APPLICATION_JSON = knownTypes.get("application/json");
        MIME_APPLICATION_XML = knownTypes.get("application/xml");
        MIME_IMAGE_JPEG = knownTypes.get("image/jpeg");
        MIME_IMAGE_TIF = knownTypes.get("image/tiff");
        MIME_IMAGE_PNG = knownTypes.get("image/png");
    }
}

