/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.core.model.api.enums;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.springframework.util.StringUtils;

public class MimeTypes {
    public static final String MIME_APPLICATION_ANDREW_INSET = "application/andrew-inset";
    public static final String MIME_APPLICATION_JAVA_ARCHIVE = "application/java-archive";
    public static final String MIME_APPLICATION_JNLP = "application/jnlp";
    public static final String MIME_APPLICATION_JSON = "application/json";
    public static final String MIME_APPLICATION_MAC_BINHEX40 = "application/mac-binhex40";
    public static final String MIME_APPLICATION_MAC_COMPACTPRO = "application/mac-compactpro";
    public static final String MIME_APPLICATION_MATHML_XML = "application/mathml+xml";
    public static final String MIME_APPLICATION_MSWORD = "application/msword";
    public static final String MIME_APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String MIME_APPLICATION_ODA = "application/oda";
    public static final String MIME_APPLICATION_PDF = "application/pdf";
    public static final String MIME_APPLICATION_POSTSCRIPT = "application/postscript";
    public static final String MIME_APPLICATION_RDF_SMIL = "application/smil";
    public static final String MIME_APPLICATION_RDF_XML = "application/rdf+xml";
    public static final String MIME_APPLICATION_SRGS = "application/srgs";
    public static final String MIME_APPLICATION_SRGS_XML = "application/srgs+xml";
    public static final String MIME_APPLICATION_TGZ = "application/tgz";
    public static final String MIME_APPLICATION_VND_MIF = "application/vnd.mif";
    public static final String MIME_APPLICATION_VND_MOZZILLA_XUL_XML = "application/vnd.mozilla.xul+xml";
    public static final String MIME_APPLICATION_VND_MSEXCEL = "application/vnd.ms-excel";
    public static final String MIME_APPLICATION_VND_MSPOWERPOINT = "application/vnd.ms-powerpoint";
    public static final String MIME_APPLICATION_VND_RNREALMEDIA = "application/vnd.rn-realmedia";
    public static final String MIME_APPLICATION_XHTML_XML = "application/xhtml+xml";
    public static final String MIME_APPLICATION_XML = "application/xml";
    public static final String MIME_APPLICATION_XML_DTD = "application/xml-dtd";
    public static final String MIME_APPLICATION_XSLT_XML = "application/xslt+xml";
    public static final String MIME_APPLICATION_X_BCPIO = "application/x-bcpio";
    public static final String MIME_APPLICATION_X_CDLINK = "application/x-cdlink";
    public static final String MIME_APPLICATION_X_CHESS_PGN = "application/x-chess-pgn";
    public static final String MIME_APPLICATION_X_CPIO = "application/x-cpio";
    public static final String MIME_APPLICATION_X_CSH = "application/x-csh";
    public static final String MIME_APPLICATION_X_DIRECTOR = "application/x-director";
    public static final String MIME_APPLICATION_X_DVI = "application/x-dvi";
    public static final String MIME_APPLICATION_X_FUTURESPLASH = "application/x-futuresplash";
    public static final String MIME_APPLICATION_X_GTAR = "application/x-gtar";
    public static final String MIME_APPLICATION_X_GZIP = "application/x-gzip";
    public static final String MIME_APPLICATION_X_HDF = "application/x-hdf";
    public static final String MIME_APPLICATION_X_JAVASCRIPT = "application/x-javascript";
    public static final String MIME_APPLICATION_X_KOAN = "application/x-koan";
    public static final String MIME_APPLICATION_X_LATEX = "application/x-latex";
    public static final String MIME_APPLICATION_X_MSDOS_PROGRAM = "application/x-msdos-program";
    public static final String MIME_APPLICATION_X_NETCDF = "application/x-netcdf";
    public static final String MIME_APPLICATION_X_OGG = "application/x-ogg";
    public static final String MIME_APPLICATION_X_RAR_COMPRESSED = "application/x-rar-compressed";
    public static final String MIME_APPLICATION_X_SH = "application/x-sh";
    public static final String MIME_APPLICATION_X_SHAR = "application/x-shar";
    public static final String MIME_APPLICATION_X_SHOCKWAVE_FLASH = "application/x-shockwave-flash";
    public static final String MIME_APPLICATION_X_STUFFIT = "application/x-stuffit";
    public static final String MIME_APPLICATION_X_SV4CPIO = "application/x-sv4cpio";
    public static final String MIME_APPLICATION_X_SV4CRC = "application/x-sv4crc";
    public static final String MIME_APPLICATION_X_TAR = "application/x-tar";
    public static final String MIME_APPLICATION_X_TCL = "application/x-tcl";
    public static final String MIME_APPLICATION_X_TEX = "application/x-tex";
    public static final String MIME_APPLICATION_X_TEXINFO = "application/x-texinfo";
    public static final String MIME_APPLICATION_X_TROFF = "application/x-troff";
    public static final String MIME_APPLICATION_X_TROFF_MAN = "application/x-troff-man";
    public static final String MIME_APPLICATION_X_TROFF_ME = "application/x-troff-me";
    public static final String MIME_APPLICATION_X_TROFF_MS = "application/x-troff-ms";
    public static final String MIME_APPLICATION_X_USTAR = "application/x-ustar";
    public static final String MIME_APPLICATION_X_WAIS_SOURCE = "application/x-wais-source";
    public static final String MIME_APPLICATION_ZIP = "application/zip";
    public static final String MIME_AUDIO_BASIC = "audio/basic";
    public static final String MIME_AUDIO_MIDI = "audio/midi";
    public static final String MIME_AUDIO_MPEG = "audio/mpeg";
    public static final String MIME_AUDIO_X_AIFF = "audio/x-aiff";
    public static final String MIME_AUDIO_X_MPEGURL = "audio/x-mpegurl";
    public static final String MIME_AUDIO_X_PN_REALAUDIO = "audio/x-pn-realaudio";
    public static final String MIME_AUDIO_X_WAV = "audio/x-wav";
    public static final String MIME_CHEMICAL_X_PDB = "chemical/x-pdb";
    public static final String MIME_CHEMICAL_X_XYZ = "chemical/x-xyz";
    public static final String MIME_IMAGE_BMP = "image/bmp";
    public static final String MIME_IMAGE_CGM = "image/cgm";
    public static final String MIME_IMAGE_GIF = "image/gif";
    public static final String MIME_IMAGE_IEF = "image/ief";
    public static final String MIME_IMAGE_JPEG = "image/jpeg";
    public static final String MIME_IMAGE_PNG = "image/png";
    public static final String MIME_IMAGE_SVG_XML = "image/svg+xml";
    public static final String MIME_IMAGE_TIFF = "image/tiff";
    public static final String MIME_IMAGE_VND_DJVU = "image/vnd.djvu";
    public static final String MIME_IMAGE_WAP_WBMP = "image/vnd.wap.wbmp";
    public static final String MIME_IMAGE_X_CMU_RASTER = "image/x-cmu-raster";
    public static final String MIME_IMAGE_X_ICON = "image/x-icon";
    public static final String MIME_IMAGE_X_PORTABLE_ANYMAP = "image/x-portable-anymap";
    public static final String MIME_IMAGE_X_PORTABLE_BITMAP = "image/x-portable-bitmap";
    public static final String MIME_IMAGE_X_PORTABLE_GRAYMAP = "image/x-portable-graymap";
    public static final String MIME_IMAGE_X_PORTABLE_PIXMAP = "image/x-portable-pixmap";
    public static final String MIME_IMAGE_X_RGB = "image/x-rgb";
    public static final String MIME_MODEL_IGES = "model/iges";
    public static final String MIME_MODEL_MESH = "model/mesh";
    public static final String MIME_MODEL_VRLM = "model/vrml";
    public static final String MIME_TEXT_CALENDAR = "text/calendar";
    public static final String MIME_TEXT_CSS = "text/css";
    public static final String MIME_TEXT_CSV = "text/csv";
    public static final String MIME_TEXT_HTML = "text/html";
    public static final String MIME_TEXT_PLAIN = "text/plain";
    public static final String MIME_TEXT_RICHTEXT = "text/richtext";
    public static final String MIME_TEXT_RTF = "text/rtf";
    public static final String MIME_TEXT_SGML = "text/sgml";
    public static final String MIME_TEXT_TAB_SEPARATED_VALUES = "text/tab-separated-values";
    public static final String MIME_TEXT_VND_WAP_WMLSCRIPT = "text/vnd.wap.wmlscript";
    public static final String MIME_TEXT_VND_WAP_XML = "text/vnd.wap.wml";
    public static final String MIME_TEXT_X_CHDR = "text/x-chdr";
    public static final String MIME_TEXT_X_COMPONENT = "text/x-component";
    public static final String MIME_TEXT_X_CPPSRC = "text/x-c++src";
    public static final String MIME_TEXT_X_CSRC = "text/x-csrc";
    public static final String MIME_TEXT_X_JAVA = "text/x-java";
    public static final String MIME_TEXT_X_SETEXT = "text/x-setext";
    public static final String MIME_VIDEO_FLV = "video/flv";
    public static final String MIME_VIDEO_MP4 = "video/mp4";
    public static final String MIME_VIDEO_MPEG = "video/mpeg";
    public static final String MIME_VIDEO_QUICKTIME = "video/quicktime";
    public static final String MIME_VIDEO_VND_MPEGURL = "video/vnd.mpegurl";
    public static final String MIME_VIDEO_WEBM = "video/webm";
    public static final String MIME_VIDEO_X_MSVIDEO = "video/x-msvideo";
    public static final String MIME_VIDEO_X_MS_WMV = "video/x-ms-wmv";
    public static final String MIME_VIDEO_X_SGI_MOVIE = "video/x-sgi-movie";
    public static final String MIME_X_CONFERENCE_X_COOLTALK = "x-conference/x-cooltalk";
    private static final HashMap<String, String> MIMETYPE_MAPPING = new HashMap<String, String>(200){
        private static final long serialVersionUID = 1L;
        {
            this.put1("abs", MimeTypes.MIME_VIDEO_MPEG);
            this.put1("ai", MimeTypes.MIME_APPLICATION_POSTSCRIPT);
            this.put1("aifc", MimeTypes.MIME_AUDIO_X_AIFF);
            this.put1("aif", MimeTypes.MIME_AUDIO_X_AIFF);
            this.put1("aiff", MimeTypes.MIME_AUDIO_X_AIFF);
            this.put1("asc", MimeTypes.MIME_TEXT_PLAIN);
            this.put1("au", MimeTypes.MIME_AUDIO_BASIC);
            this.put1("avi", MimeTypes.MIME_VIDEO_X_MSVIDEO);
            this.put1("bat", MimeTypes.MIME_APPLICATION_X_MSDOS_PROGRAM);
            this.put1("bcpio", MimeTypes.MIME_APPLICATION_X_BCPIO);
            this.put1("bin", MimeTypes.MIME_APPLICATION_OCTET_STREAM);
            this.put1("bmp", MimeTypes.MIME_IMAGE_BMP);
            this.put1("c", MimeTypes.MIME_TEXT_X_CSRC);
            this.put1("cc", MimeTypes.MIME_TEXT_X_CPPSRC);
            this.put1("cdf", MimeTypes.MIME_APPLICATION_X_NETCDF);
            this.put1("cgm", MimeTypes.MIME_IMAGE_CGM);
            this.put1("chh", MimeTypes.MIME_TEXT_PLAIN);
            this.put1("class", MimeTypes.MIME_APPLICATION_OCTET_STREAM);
            this.put1("cmd", MimeTypes.MIME_TEXT_PLAIN);
            this.put1("com", MimeTypes.MIME_APPLICATION_X_MSDOS_PROGRAM);
            this.put1("cpio", MimeTypes.MIME_APPLICATION_X_CPIO);
            this.put1("cpp", MimeTypes.MIME_TEXT_X_CPPSRC);
            this.put1("cpt", MimeTypes.MIME_APPLICATION_MAC_COMPACTPRO);
            this.put1("csh", MimeTypes.MIME_APPLICATION_X_CSH);
            this.put1("css", MimeTypes.MIME_TEXT_CSS);
            this.put1("csv", MimeTypes.MIME_TEXT_CSV);
            this.put1("cxx", MimeTypes.MIME_TEXT_X_CPPSRC);
            this.put1("dcr", MimeTypes.MIME_APPLICATION_X_DIRECTOR);
            this.put1("dir", MimeTypes.MIME_APPLICATION_X_DIRECTOR);
            this.put1("djv", MimeTypes.MIME_IMAGE_VND_DJVU);
            this.put1("djvu", MimeTypes.MIME_IMAGE_VND_DJVU);
            this.put1("dll", MimeTypes.MIME_APPLICATION_X_MSDOS_PROGRAM);
            this.put1("dmg", MimeTypes.MIME_APPLICATION_OCTET_STREAM);
            this.put1("dms", MimeTypes.MIME_APPLICATION_OCTET_STREAM);
            this.put1("doc", MimeTypes.MIME_APPLICATION_MSWORD);
            this.put1("dtd", MimeTypes.MIME_APPLICATION_XML_DTD);
            this.put1("dvi", MimeTypes.MIME_APPLICATION_X_DVI);
            this.put1("dxr", MimeTypes.MIME_APPLICATION_X_DIRECTOR);
            this.put1("eps", MimeTypes.MIME_APPLICATION_POSTSCRIPT);
            this.put1("etx", MimeTypes.MIME_TEXT_X_SETEXT);
            this.put1("exe", MimeTypes.MIME_APPLICATION_X_MSDOS_PROGRAM);
            this.put1("ez", MimeTypes.MIME_APPLICATION_ANDREW_INSET);
            this.put1("flv", MimeTypes.MIME_VIDEO_FLV);
            this.put1("gif", MimeTypes.MIME_IMAGE_GIF);
            this.put1("gram", MimeTypes.MIME_APPLICATION_SRGS);
            this.put1("grxml", MimeTypes.MIME_APPLICATION_SRGS_XML);
            this.put1("gtar", MimeTypes.MIME_APPLICATION_X_GTAR);
            this.put1("gz", MimeTypes.MIME_APPLICATION_X_GZIP);
            this.put1("gzip", MimeTypes.MIME_APPLICATION_X_GZIP);
            this.put1("h", MimeTypes.MIME_TEXT_X_CHDR);
            this.put1("hdf", MimeTypes.MIME_APPLICATION_X_HDF);
            this.put1("hqx", MimeTypes.MIME_APPLICATION_MAC_BINHEX40);
            this.put1("htc", MimeTypes.MIME_TEXT_X_COMPONENT);
            this.put1("htm", MimeTypes.MIME_TEXT_HTML);
            this.put1("html", MimeTypes.MIME_TEXT_HTML);
            this.put1("ice", MimeTypes.MIME_X_CONFERENCE_X_COOLTALK);
            this.put1("ico", MimeTypes.MIME_IMAGE_X_ICON);
            this.put1("ics", MimeTypes.MIME_TEXT_CALENDAR);
            this.put1("ief", MimeTypes.MIME_IMAGE_IEF);
            this.put1("ifb", MimeTypes.MIME_TEXT_CALENDAR);
            this.put1("iges", MimeTypes.MIME_MODEL_IGES);
            this.put1("igs", MimeTypes.MIME_MODEL_IGES);
            this.put1("ini", MimeTypes.MIME_TEXT_PLAIN);
            this.put1("jar", MimeTypes.MIME_APPLICATION_JAVA_ARCHIVE);
            this.put1("java", MimeTypes.MIME_TEXT_X_JAVA);
            this.put1("jnlp", MimeTypes.MIME_APPLICATION_JNLP);
            this.put1("jpg", MimeTypes.MIME_IMAGE_JPEG);
            this.put1("jpeg", MimeTypes.MIME_IMAGE_JPEG);
            this.put1("js", MimeTypes.MIME_APPLICATION_X_JAVASCRIPT);
            this.put1("json", MimeTypes.MIME_APPLICATION_JSON);
            this.put1("kar", MimeTypes.MIME_AUDIO_MIDI);
            this.put1("latex", MimeTypes.MIME_APPLICATION_X_LATEX);
            this.put1("lha", MimeTypes.MIME_APPLICATION_OCTET_STREAM);
            this.put1("lzh", MimeTypes.MIME_APPLICATION_OCTET_STREAM);
            this.put1("m3u", MimeTypes.MIME_AUDIO_X_MPEGURL);
            this.put1("m4u", MimeTypes.MIME_VIDEO_VND_MPEGURL);
            this.put1("man", MimeTypes.MIME_APPLICATION_X_TROFF_MAN);
            this.put1("mathml", MimeTypes.MIME_APPLICATION_MATHML_XML);
            this.put1("me", MimeTypes.MIME_APPLICATION_X_TROFF_ME);
            this.put1("mesh", MimeTypes.MIME_MODEL_MESH);
            this.put1("mid", MimeTypes.MIME_AUDIO_MIDI);
            this.put1("midi", MimeTypes.MIME_AUDIO_MIDI);
            this.put1("mif", MimeTypes.MIME_APPLICATION_VND_MIF);
            this.put1("mov", MimeTypes.MIME_VIDEO_QUICKTIME);
            this.put1("movie", MimeTypes.MIME_VIDEO_X_SGI_MOVIE);
            this.put1("mp1", MimeTypes.MIME_AUDIO_MPEG);
            this.put1("mp2", MimeTypes.MIME_AUDIO_MPEG);
            this.put1("mp3", MimeTypes.MIME_AUDIO_MPEG);
            this.put1("mp4", MimeTypes.MIME_VIDEO_MP4);
            this.put1("mpe", MimeTypes.MIME_VIDEO_MPEG);
            this.put1("mpeg", MimeTypes.MIME_VIDEO_MPEG);
            this.put1("mpg", MimeTypes.MIME_VIDEO_MPEG);
            this.put1("mpga", MimeTypes.MIME_AUDIO_MPEG);
            this.put1("ms", MimeTypes.MIME_APPLICATION_X_TROFF_MS);
            this.put1("msh", MimeTypes.MIME_MODEL_MESH);
            this.put1("mxu", MimeTypes.MIME_VIDEO_VND_MPEGURL);
            this.put1("nc", MimeTypes.MIME_APPLICATION_X_NETCDF);
            this.put1("oda", MimeTypes.MIME_APPLICATION_ODA);
            this.put1("ogg", MimeTypes.MIME_APPLICATION_X_OGG);
            this.put1("pbm", MimeTypes.MIME_IMAGE_X_PORTABLE_BITMAP);
            this.put1("pdb", MimeTypes.MIME_CHEMICAL_X_PDB);
            this.put1("pdf", MimeTypes.MIME_APPLICATION_PDF);
            this.put1("pgm", MimeTypes.MIME_IMAGE_X_PORTABLE_GRAYMAP);
            this.put1("pgn", MimeTypes.MIME_APPLICATION_X_CHESS_PGN);
            this.put1("png", MimeTypes.MIME_IMAGE_PNG);
            this.put1("pnm", MimeTypes.MIME_IMAGE_X_PORTABLE_ANYMAP);
            this.put1("ppm", MimeTypes.MIME_IMAGE_X_PORTABLE_PIXMAP);
            this.put1("ppt", MimeTypes.MIME_APPLICATION_VND_MSPOWERPOINT);
            this.put1("ps", MimeTypes.MIME_APPLICATION_POSTSCRIPT);
            this.put1("qt", MimeTypes.MIME_VIDEO_QUICKTIME);
            this.put1("ra", MimeTypes.MIME_AUDIO_X_PN_REALAUDIO);
            this.put1("ram", MimeTypes.MIME_AUDIO_X_PN_REALAUDIO);
            this.put1("rar", MimeTypes.MIME_APPLICATION_X_RAR_COMPRESSED);
            this.put1("ras", MimeTypes.MIME_IMAGE_X_CMU_RASTER);
            this.put1("rdf", MimeTypes.MIME_APPLICATION_RDF_XML);
            this.put1("rgb", MimeTypes.MIME_IMAGE_X_RGB);
            this.put1("rm", MimeTypes.MIME_APPLICATION_VND_RNREALMEDIA);
            this.put1("roff", MimeTypes.MIME_APPLICATION_X_TROFF);
            this.put1("rtf", MimeTypes.MIME_TEXT_RTF);
            this.put1("rtx", MimeTypes.MIME_TEXT_RICHTEXT);
            this.put1("sgm", MimeTypes.MIME_TEXT_SGML);
            this.put1("sgml", MimeTypes.MIME_TEXT_SGML);
            this.put1("sh", MimeTypes.MIME_APPLICATION_X_SH);
            this.put1("shar", MimeTypes.MIME_APPLICATION_X_SHAR);
            this.put1("silo", MimeTypes.MIME_MODEL_MESH);
            this.put1("sit", MimeTypes.MIME_APPLICATION_X_STUFFIT);
            this.put1("skd", MimeTypes.MIME_APPLICATION_X_KOAN);
            this.put1("skm", MimeTypes.MIME_APPLICATION_X_KOAN);
            this.put1("skp", MimeTypes.MIME_APPLICATION_X_KOAN);
            this.put1("skt", MimeTypes.MIME_APPLICATION_X_KOAN);
            this.put1("smi", MimeTypes.MIME_APPLICATION_RDF_SMIL);
            this.put1("smil", MimeTypes.MIME_APPLICATION_RDF_SMIL);
            this.put1("snd", MimeTypes.MIME_AUDIO_BASIC);
            this.put1("so", MimeTypes.MIME_APPLICATION_OCTET_STREAM);
            this.put1("spl", MimeTypes.MIME_APPLICATION_X_FUTURESPLASH);
            this.put1("src", MimeTypes.MIME_APPLICATION_X_WAIS_SOURCE);
            this.put1("sv4cpio", MimeTypes.MIME_APPLICATION_X_SV4CPIO);
            this.put1("sv4crc", MimeTypes.MIME_APPLICATION_X_SV4CRC);
            this.put1("svg", MimeTypes.MIME_IMAGE_SVG_XML);
            this.put1("swf", MimeTypes.MIME_APPLICATION_X_SHOCKWAVE_FLASH);
            this.put1("t", MimeTypes.MIME_APPLICATION_X_TROFF);
            this.put1("tar", MimeTypes.MIME_APPLICATION_X_TAR);
            this.put1("tcl", MimeTypes.MIME_APPLICATION_X_TCL);
            this.put1("tex", MimeTypes.MIME_APPLICATION_X_TEX);
            this.put1("texi", MimeTypes.MIME_APPLICATION_X_TEXINFO);
            this.put1("texinfo", MimeTypes.MIME_APPLICATION_X_TEXINFO);
            this.put1("tgz", MimeTypes.MIME_APPLICATION_TGZ);
            this.put1("tif", MimeTypes.MIME_IMAGE_TIFF);
            this.put1("tiff", MimeTypes.MIME_IMAGE_TIFF);
            this.put1("tr", MimeTypes.MIME_APPLICATION_X_TROFF);
            this.put1("tsv", MimeTypes.MIME_TEXT_TAB_SEPARATED_VALUES);
            this.put1("txt", MimeTypes.MIME_TEXT_PLAIN);
            this.put1("ustar", MimeTypes.MIME_APPLICATION_X_USTAR);
            this.put1("vcd", MimeTypes.MIME_APPLICATION_X_CDLINK);
            this.put1("vrlm", MimeTypes.MIME_MODEL_VRLM);
            this.put1("wav", MimeTypes.MIME_AUDIO_X_WAV);
            this.put1("wbmp", MimeTypes.MIME_IMAGE_WAP_WBMP);
            this.put1("webm", MimeTypes.MIME_VIDEO_WEBM);
            this.put1("wml", MimeTypes.MIME_TEXT_VND_WAP_XML);
            this.put1("wmls", MimeTypes.MIME_TEXT_VND_WAP_WMLSCRIPT);
            this.put1("wmv", MimeTypes.MIME_VIDEO_X_MS_WMV);
            this.put1("wrl", MimeTypes.MIME_MODEL_VRLM);
            this.put1("xht", MimeTypes.MIME_APPLICATION_XHTML_XML);
            this.put1("xhtml", MimeTypes.MIME_APPLICATION_XHTML_XML);
            this.put1("xls", MimeTypes.MIME_APPLICATION_VND_MSEXCEL);
            this.put1("xml", MimeTypes.MIME_APPLICATION_XML);
            this.put1("xsl", MimeTypes.MIME_APPLICATION_XML);
            this.put1("xslt", MimeTypes.MIME_APPLICATION_XSLT_XML);
            this.put1("xul", MimeTypes.MIME_APPLICATION_VND_MOZZILLA_XUL_XML);
            this.put1("xyz", MimeTypes.MIME_CHEMICAL_X_XYZ);
            this.put1("zip", MimeTypes.MIME_APPLICATION_ZIP);
        }

        private void put1(String key, String value) {
            if (this.put(key, value) != null) {
                throw new IllegalArgumentException("Duplicated extension: " + key);
            }
        }
    };

    public static String getExtension(String contentType) {
        for (Map.Entry<String, String> entrySet : MIMETYPE_MAPPING.entrySet()) {
            String key = entrySet.getKey();
            String value = entrySet.getValue();
            if (!value.equals(contentType)) continue;
            return key;
        }
        return null;
    }

    public static String getExtension(MimeType mimeType) {
        return MimeTypes.getExtension(mimeType.toString());
    }

    public static MimeType getMimeType(String ext) {
        MimeType mimeType;
        String mimeTypeStr = MimeTypes.lookupMimeType(ext);
        if (mimeTypeStr == null) {
            mimeTypeStr = MIME_APPLICATION_OCTET_STREAM;
        }
        try {
            mimeType = new MimeType(mimeTypeStr);
        }
        catch (MimeTypeParseException ex) {
            return null;
        }
        return mimeType;
    }

    public static MimeType getMimeType(URI uri) {
        try {
            String filename = uri.toURL().getFile();
            String extension = StringUtils.getFilenameExtension((String)filename);
            MimeType mimetype = MimeTypes.getMimeType(extension);
            return mimetype;
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public static String lookupMimeType(String ext) {
        return MIMETYPE_MAPPING.get(ext.toLowerCase());
    }

    public static void main(String[] args) {
        System.out.println(MIMETYPE_MAPPING.size());
    }

    public static void registerMimeType(String ext, String mimeType) {
        MIMETYPE_MAPPING.put(ext, mimeType);
    }
}

