/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.template.website.springboot.repository;

import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.template.website.springboot.repository.LocaleRepository;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class LocaleRepositoryImpl
implements LocaleRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocaleRepositoryImpl.class);
    @Autowired
    private CudamiLocalesClient cudamiLocalesClient;

    public Locale getDefault() {
        try {
            return this.cudamiLocalesClient.getDefaultLanguage();
        }
        catch (Exception e) {
            LOGGER.error("Cannot get default locale: " + e, (Throwable)e);
            return null;
        }
    }

    public List<Locale> getAll() {
        try {
            return this.cudamiLocalesClient.findAllLanguages().stream().map(language -> new Locale((String)language)).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error("Cannot get all locales: " + e, (Throwable)e);
            return null;
        }
    }
}

