/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.legacy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.openjson.JSONArray;
import com.github.openjson.JSONException;
import com.github.openjson.JSONObject;
import de.digitalcollections.cudami.server.controller.legacy.model.LegacyFiltering;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.Order;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class V5MigrationHelper {
    public static List<Order> migrate(List<Order> sortBy) {
        List result = null;
        if (sortBy != null) {
            result = sortBy.stream().map(o -> {
                o.setIgnoreCase(true);
                return o;
            }).collect(Collectors.toList());
        }
        return result;
    }

    public static String migrate(PageResponse<?> pageResponse, ObjectMapper objectMapper) throws JsonProcessingException {
        if (pageResponse == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject(objectMapper.writeValueAsString(pageResponse));
        return V5MigrationHelper.migrateToV5((JSONObject)jsonObject, (ObjectMapper)objectMapper);
    }

    public static String migrateToV5(String unmigratedJson) {
        String migratedJson = unmigratedJson.replaceAll("executedSearchTerm", "query");
        migratedJson = migratedJson.replaceAll("searchTerm", "query");
        return migratedJson;
    }

    public static String migrateToV5(JSONObject jsonObject, ObjectMapper objectMapper) throws JsonMappingException, JsonProcessingException, JSONException {
        if (jsonObject == null) {
            return null;
        }
        if (jsonObject.has("pageRequest")) {
            JSONObject sorting;
            JSONObject pageRequest = (JSONObject)jsonObject.get("pageRequest");
            if (pageRequest.has("sorting") && (sorting = (JSONObject)pageRequest.get("sorting")).has("orders")) {
                JSONArray orders = (JSONArray)sorting.get("orders");
                JSONObject migratedSorting = new JSONObject();
                Iterator it = orders.iterator();
                while (it.hasNext()) {
                    JSONObject order;
                    Direction direction = Direction.fromString((String)((String)(order = (JSONObject)it.next()).get("direction")));
                    order.put("ascending", direction == Direction.ASC);
                    order.put("descending", direction == Direction.DESC);
                    migratedSorting.append("orders", (Object)order);
                }
                pageRequest.put("sorting", (Object)migratedSorting);
            }
            if (pageRequest.has("filtering")) {
                LegacyFiltering legacyFiltering = new LegacyFiltering((Filtering)objectMapper.readValue(pageRequest.getJSONObject("filtering").toString(), Filtering.class));
                pageRequest.put("filtering", (Object)new JSONObject(objectMapper.writeValueAsString((Object)legacyFiltering)));
                if (legacyFiltering.getFilterCriterionFor("label") != null) {
                    pageRequest.put("query", legacyFiltering.getFilterCriterionFor("label").getValue());
                    jsonObject.put("query", legacyFiltering.getFilterCriterionFor("label").getValue());
                }
            }
            jsonObject.put("pageRequest", (Object)pageRequest);
        }
        if (jsonObject.has("content")) {
            JSONArray content = jsonObject.getJSONArray("content");
            content.forEach(obj -> {
                JSONObject item;
                if (obj instanceof JSONObject && (item = (JSONObject)obj).has("entityType")) {
                    switch (item.getString("entityType")) {
                        case "DIGITAL_OBJECT": {
                            if (!item.isNull("fileResources")) break;
                            item.put("fileResources", (Object)new JSONArray());
                            break;
                        }
                        case "ARTICLE": {
                            if (!item.isNull("creators")) break;
                            item.put("creators", (Object)new JSONArray());
                            break;
                        }
                    }
                }
            });
        }
        return V5MigrationHelper.migrateToV5((String)jsonObject.toString());
    }

    private V5MigrationHelper() {
    }
}

