/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.converter;

import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.FilterLogicalOperator;
import de.digitalcollections.model.list.filtering.FilterOperation;
import de.digitalcollections.model.list.filtering.Filtering;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class StringToFilterCriteriaGenericConverter
implements GenericConverter {
    @Autowired
    private ConversionService conversionService;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        HashSet<GenericConverter.ConvertiblePair> convertibleTypes = new HashSet<GenericConverter.ConvertiblePair>();
        convertibleTypes.add(new GenericConverter.ConvertiblePair(String.class, FilterCriterion.class));
        convertibleTypes.add(new GenericConverter.ConvertiblePair(String.class, Filtering.class));
        return convertibleTypes;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        if (!(source instanceof String)) {
            throw new IllegalArgumentException("`source` parameter must be of type `String`.");
        }
        String sourceString = (String)source;
        sourceString = URLDecoder.decode(sourceString, StandardCharsets.UTF_8);
        if (!StringUtils.hasText((String)sourceString)) {
            return null;
        }
        if (!sourceString.contains(":")) {
            throw new IllegalArgumentException("No separator ':' found");
        }
        if (targetType.getType().equals(FilterCriterion.class)) {
            return this.buildFilterCriterion(sourceString);
        }
        if (targetType.getType().equals(Filtering.class)) {
            return this.buildFiltering(sourceString);
        }
        throw new UnsupportedOperationException();
    }

    private Filtering buildFiltering(String filter) {
        if (filter.matches("[^{].+[^}]")) {
            filter = "{%s}".formatted(filter);
        }
        Matcher filterCriteriaStrings = Pattern.compile("[^\\\\]?[{](.+?[^\\\\])[}]").matcher(filter);
        Filtering result = new Filtering();
        while (filterCriteriaStrings.find()) {
            List criterionStrings = Arrays.stream(filterCriteriaStrings.group(1).split("(?<=[^\\\\]);", 0)).collect(Collectors.toCollection(ArrayList::new));
            AtomicReference<FilterLogicalOperator> link = new AtomicReference<FilterLogicalOperator>(FilterLogicalOperator.AND);
            criterionStrings.stream().filter(s -> s.matches("(?iu)\\s*\\$\\p{Alpha}+\\s*")).findFirst().ifPresent(s -> {
                link.set(Optional.ofNullable(FilterLogicalOperator.fromValue((String)s.strip().substring(1))).orElse(FilterLogicalOperator.AND));
                criterionStrings.remove(s);
            });
            List<FilterCriterion> criterions = criterionStrings.stream().map(s -> s.replaceAll("\\\\([;{}])", "$1")).map(arg_0 -> this.buildFilterCriterion(arg_0)).toList();
            result.add(link.get(), criterions);
        }
        return result;
    }

    private FilterCriterion buildFilterCriterion(String filterSource) {
        FilterOperation filterOperation;
        boolean newStyle = false;
        String[] filterParts = filterSource.split(":");
        if (filterParts.length > 2 && FilterOperation.fromValue((String)filterParts[1]) != null) {
            newStyle = true;
        } else if (filterParts.length == 2 && (filterOperation = FilterOperation.fromValue((String)filterParts[1])) != null && filterOperation.getOperandCount() == FilterOperation.OperandCount.NO_VALUE) {
            newStyle = true;
        }
        String expression = null;
        boolean isNativeExpression = false;
        String operationAcronym = null;
        StringBuilder operationValue = new StringBuilder();
        if (newStyle) {
            expression = filterParts[0];
            if (expression.startsWith("[") && expression.endsWith("]")) {
                isNativeExpression = true;
                expression = expression.substring(1, expression.length() - 1);
            }
            operationAcronym = filterParts[1];
            for (int i = 2; i < filterParts.length; ++i) {
                if (i > 2) {
                    operationValue.append(":");
                }
                operationValue.append(filterParts[i]);
            }
        } else {
            int separatorPosition = filterSource.indexOf(58);
            operationAcronym = filterSource.substring(0, separatorPosition);
            operationValue.append(filterSource.substring(separatorPosition + 1));
        }
        if (operationAcronym == null) {
            throw new IllegalArgumentException("No operation acronym found");
        }
        FilterOperation filterOperation2 = FilterOperation.fromValue((String)operationAcronym);
        return StringToFilterCriteriaGenericConverter.createFilterCriterion(String.class, (String)expression, (boolean)isNativeExpression, (FilterOperation)filterOperation2, (String)operationValue.toString(), (ConversionService)this.conversionService);
    }

    public static <T> FilterCriterion<T> createFilterCriterion(Class<T> targetClass, String expression, boolean isNativeExpression, FilterOperation filterOperation, String operationValue, ConversionService conversionService) throws IllegalArgumentException {
        if (filterOperation.getOperandCount() == FilterOperation.OperandCount.NO_VALUE) {
            FilterCriterion fc = new FilterCriterion(expression, isNativeExpression, filterOperation, null, null, null, null);
            return fc;
        }
        if (filterOperation.getOperandCount() == FilterOperation.OperandCount.SINGLEVALUE) {
            if (operationValue == null) {
                throw new IllegalArgumentException("No operation value found");
            }
            Object value = conversionService.convert((Object)operationValue, targetClass);
            FilterCriterion fc = new FilterCriterion(expression, isNativeExpression, filterOperation, value);
            return fc;
        }
        if (filterOperation.getOperandCount() == FilterOperation.OperandCount.MULTIVALUE) {
            if (operationValue == null) {
                throw new IllegalArgumentException("No operation values found");
            }
            String[] operationValues = StringUtils.tokenizeToStringArray((String)operationValue, (String)",");
            if (operationValues == null || operationValues.length < 1) {
                throw new IllegalArgumentException("Operation values can't be empty");
            }
            ArrayList convertedValues = new ArrayList();
            convertedValues.addAll(Arrays.stream(operationValues).map(s -> conversionService.convert(s, targetClass)).collect(Collectors.toList()));
            FilterCriterion fc = new FilterCriterion(expression, isNativeExpression, filterOperation, null, null, null, convertedValues);
            return fc;
        }
        if (filterOperation.getOperandCount() == FilterOperation.OperandCount.MIN_MAX_VALUES) {
            if (operationValue == null) {
                throw new IllegalArgumentException("No operation values found");
            }
            String[] operationValues = StringUtils.tokenizeToStringArray((String)operationValue, (String)",");
            if (operationValues == null || operationValues.length < 1) {
                throw new IllegalArgumentException("Operation values can't be empty");
            }
            if (operationValues.length != 2) {
                throw new IllegalArgumentException("For min/max operation two values are expected");
            }
            Comparable minValue = null;
            Comparable maxValue = null;
            Comparable value1 = (Comparable)conversionService.convert((Object)operationValues[0], targetClass);
            Comparable value2 = (Comparable)conversionService.convert((Object)operationValues[1], targetClass);
            if (value1 != null && value2 != null) {
                if (value1.compareTo(value2) > 0) {
                    minValue = value2;
                    maxValue = value1;
                } else {
                    minValue = value1;
                    maxValue = value2;
                }
            }
            FilterCriterion fc = new FilterCriterion(expression, isNativeExpression, filterOperation, null, minValue, maxValue, null);
            return fc;
        }
        return null;
    }
}

