/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.web;

import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifiableService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.web.WebpageService;
import de.digitalcollections.cudami.server.controller.identifiable.AbstractIdentifiableController;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Webpage controller")
public class WebpageController
extends AbstractIdentifiableController<Webpage> {
    private final LocaleService localeService;
    private final WebpageService service;

    public WebpageController(LocaleService localeService, WebpageService webpageService) {
        this.localeService = localeService;
        this.service = webpageService;
    }

    @Operation(summary="Add file resource related to webpage")
    @PostMapping(value={"/v6/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/related/fileresources/{fileResourceUuid}", "/v5/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/related/fileresources/{fileResourceUuid}", "/v2/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/related/fileresources/{fileResourceUuid}", "/latest/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/related/fileresources/{fileResourceUuid}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void addRelatedFileResource(@PathVariable UUID uuid, @PathVariable UUID fileResourceUuid) throws ServiceException {
        this.service.addRelatedFileresource((Identifiable)((Webpage)this.buildExampleWithUuid(uuid)), ((FileResource.FileResourceBuilder)FileResource.builder().uuid(fileResourceUuid)).build());
    }

    @Operation(summary="Get all webpages as (paged, sorted, filtered) list")
    @GetMapping(value={"/v6/webpages"}, produces={"application/json"})
    public PageResponse<Webpage> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering) throws ServiceException {
        return super.find(pageNumber, pageSize, sortBy, filterCriteria, filtering);
    }

    @Operation(summary="Get all (active) children of a webpage as (paged, sorted, filtered) list")
    @GetMapping(value={"/v6/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/children"}, produces={"application/json"})
    public PageResponse<Webpage> findSubpages(@Parameter(example="", description="UUID of the parent webpage, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering, @RequestParam(name="active", required=false) String active) throws ServiceException {
        PageRequest pageRequest = this.createPageRequest(Webpage.class, pageNumber, pageSize, sortBy, filterCriteria, filtering);
        if (active != null) {
            return this.service.findActiveChildren((Webpage)this.buildExampleWithUuid(uuid), pageRequest);
        }
        return this.service.findChildren((Identifiable)((Webpage)this.buildExampleWithUuid(uuid)), pageRequest);
    }

    @Operation(summary="Get the breadcrumb for a webpage")
    @GetMapping(value={"/v6/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/breadcrumb", "/v5/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/breadcrumb", "/v3/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/breadcrumb", "/latest/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/breadcrumb"}, produces={"application/json"})
    public ResponseEntity<BreadcrumbNavigation> getBreadcrumbNavigation(@Parameter(example="", description="UUID of the webpage, e.g. <tt>6119d8e9-9c92-4091-8dcb-bc4053385406</tt>") @PathVariable(value="uuid") UUID uuid, @Parameter(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale) throws ServiceException {
        BreadcrumbNavigation breadcrumbNavigation = pLocale == null ? this.service.getBreadcrumbNavigation((Identifiable)((Webpage)this.buildExampleWithUuid(uuid))) : this.service.getBreadcrumbNavigation((Identifiable)((Webpage)this.buildExampleWithUuid(uuid)), pLocale, this.localeService.getDefaultLocale());
        if (breadcrumbNavigation == null || breadcrumbNavigation.getNavigationItems().isEmpty()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)breadcrumbNavigation, HttpStatus.OK);
    }

    @Operation(summary="Get a webpage by uuid")
    @GetMapping(value={"/v6/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v5/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/latest/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public ResponseEntity<Webpage> getByUuid(@Parameter(example="", description="UUID of the webpage, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid, @Parameter(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale, @Parameter(name="active", description="If set, object will only be returned if active") @RequestParam(name="active", required=false) String active) throws ServiceException {
        Webpage example = (Webpage)this.buildExampleWithUuid(uuid);
        Webpage webpage = active != null ? (pLocale == null ? this.service.getByExampleAndActive(example) : this.service.getByExampleAndActiveAndLocale(example, pLocale)) : (pLocale == null ? (Webpage)this.service.getByExample((UniqueObject)example) : (Webpage)this.service.getByExampleAndLocale((Identifiable)example, pLocale));
        return new ResponseEntity((Object)webpage, webpage != null ? HttpStatus.OK : HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Get a list of webpages by UUID")
    @GetMapping(value={"/v6/webpages/list/{uuids}"}, produces={"application/json"})
    public PageResponse<Webpage> getByUuids(@PathVariable List<UUID> uuids) throws ServiceException {
        return super.getByUuids(uuids);
    }

    @Operation(summary="Get a list of webpages by UUID")
    @PostMapping(value={"/v6/webpages/list"}, produces={"application/json"})
    public PageResponse<Webpage> getByManyUuids(@RequestBody List<UUID> uuids) throws ServiceException {
        return super.getByUuids(uuids);
    }

    @Operation(summary="Get (active or all) children of a webpage recursivly as JSON")
    @GetMapping(value={"/v6/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/childrentree", "/v5/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/childrentree", "/latest/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/childrentree"}, produces={"application/json"})
    public List<Webpage> getChildrenTree(@Parameter(example="", description="UUID of the root webpage, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid, @Parameter(name="active", description="If set, only active children will be returned") @RequestParam(name="active", required=false) String active) throws ServiceException {
        return active != null ? this.service.getActiveChildrenTree((Webpage)this.buildExampleWithUuid(uuid)) : this.service.getChildrenTree((Webpage)this.buildExampleWithUuid(uuid));
    }

    @Operation(summary="Get parent of a webpage as JSON")
    @GetMapping(value={"/v6/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/parent", "/v5/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/parent", "/v3/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/parent", "/latest/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/parent"}, produces={"application/json"})
    public Webpage getParent(@Parameter(example="", description="UUID of the webpage, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid) throws ServiceException {
        return (Webpage)this.service.getParent((Identifiable)((Webpage)this.buildExampleWithUuid(uuid)));
    }

    @Operation(summary="Get file resources related to webpage")
    @GetMapping(value={"/v6/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/related/fileresources", "/v5/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/related/fileresources", "/v2/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/related/fileresources", "/latest/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/related/fileresources"}, produces={"application/json"})
    public PageResponse<FileResource> findRelatedFileResources(@PathVariable UUID uuid) throws ServiceException {
        PageRequest pageRequest = PageRequest.builder().pageNumber(0).pageSize(25).build();
        return this.service.findRelatedFileResources((Identifiable)((Webpage)this.buildExampleWithUuid(uuid)), pageRequest);
    }

    protected IdentifiableService<Webpage> getService() {
        return this.service;
    }

    @Operation(summary="Get website of a webpage as JSON")
    @GetMapping(value={"/v6/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/website", "/v5/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/website", "/v3/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/website", "/latest/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/website"}, produces={"application/json"})
    public Website getWebsite(@Parameter(example="", description="UUID of the webpage, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid) throws ServiceException {
        return this.service.getWebsite((Webpage)this.buildExampleWithUuid(uuid));
    }

    @Operation(summary="Save a newly created webpage")
    @PostMapping(value={"/v6/webpages/{parentWebpageUuid}/webpage", "/v5/webpages/{parentWebpageUuid}/webpage", "/v2/webpages/{parentWebpageUuid}/webpage", "/latest/webpages/{parentWebpageUuid}/webpage"}, produces={"application/json"})
    public Webpage saveWithParentWebpage(@PathVariable UUID parentWebpageUuid, @RequestBody Webpage webpage, BindingResult errors) throws ServiceException, ValidationException {
        return (Webpage)this.service.saveWithParent((Identifiable)webpage, (Identifiable)((Webpage)this.buildExampleWithUuid(parentWebpageUuid)));
    }

    @Operation(summary="Save a newly created top-level webpage")
    @PostMapping(value={"/v6/websites/{parentWebsiteUuid}/webpage", "/v5/websites/{parentWebsiteUuid}/webpage", "/v2/websites/{parentWebsiteUuid}/webpage", "/latest/websites/{parentWebsiteUuid}/webpage"}, produces={"application/json"})
    public Webpage saveWithParentWebsite(@PathVariable UUID parentWebsiteUuid, @RequestBody Webpage webpage, BindingResult errors) throws ServiceException {
        return this.service.saveWithParentWebsite(webpage, ((Website.WebsiteBuilder)Website.builder().uuid(parentWebsiteUuid)).build());
    }

    @Operation(summary="Update a webpage")
    @PutMapping(value={"/v6/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v5/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v2/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/latest/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public Webpage update(@PathVariable UUID uuid, @RequestBody Webpage webpage, BindingResult errors) throws ServiceException, ValidationException {
        return (Webpage)super.update(uuid, (UniqueObject)webpage, errors);
    }

    @Operation(summary="Update the order of a webpage's children")
    @PutMapping(value={"/v6/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/children", "/v5/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/children", "/v3/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/children", "/latest/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/children"}, produces={"application/json"})
    public ResponseEntity updateChildrenOrder(@Parameter(example="", description="UUID of the webpage") @PathVariable(value="uuid") UUID uuid, @Parameter(example="", description="List of the children") @RequestBody List<Webpage> rootPages) throws ServiceException {
        boolean successful = this.service.updateChildrenOrder((Identifiable)((Webpage)this.buildExampleWithUuid(uuid)), rootPages);
        return successful ? new ResponseEntity(HttpStatus.NO_CONTENT) : new ResponseEntity(HttpStatus.NOT_FOUND);
    }
}

