/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.resource;

import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifiableService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.FileResourceMetadataService;
import de.digitalcollections.cudami.server.controller.identifiable.AbstractIdentifiableController;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Fileresource controller")
public class FileResourceMetadataController
extends AbstractIdentifiableController<FileResource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResourceMetadataController.class);
    private final FileResourceMetadataService<FileResource> service;

    public FileResourceMetadataController(@Qualifier(value="fileResourceMetadataService") FileResourceMetadataService<FileResource> metadataService) {
        this.service = metadataService;
    }

    @Operation(summary="Get all fileresources as (paged, sorted, filtered) list")
    @GetMapping(value={"/v6/fileresources"}, produces={"application/json"})
    public PageResponse<FileResource> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering) throws ServiceException {
        return super.find(pageNumber, pageSize, sortBy, filterCriteria, filtering);
    }

    @Operation(summary="Get all fileresources of given type as (paged, sorted, filtered) list")
    @GetMapping(value={"/v6/fileresources/type/{type}"}, produces={"application/json"})
    public PageResponse<FileResource> findByType(@Parameter(example="", description="Type of the fileresource, e.g. <tt>image</tt>") @PathVariable(value="type") String type, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering) throws ServiceException {
        PageRequest pageRequest = this.createPageRequest(FileResource.class, pageNumber, pageSize, sortBy, filterCriteria, filtering);
        String prefix = switch (type) {
            case "application" -> "application/";
            case "audio" -> "audio/";
            case "image" -> "image/";
            case "linkeddata" -> "application/ld";
            case "text" -> "text/";
            case "video" -> "video/";
            default -> {
                LOGGER.warn("Unsupported mimeType for type='{}'", (Object)type);
                yield null;
            }
        };
        if (prefix != null) {
            Filtering mimeFiltering = Filtering.builder().add(FilterCriterion.builder().withExpression("mimeType").startsWith((Object)prefix).build()).build();
            pageRequest.add(mimeFiltering);
        }
        return this.service.find(pageRequest);
    }

    @Operation(summary="Get a fileresource by namespace and id", description="Separate namespace and id with a colon, e.g. foo:bar. It is also possible, to add a .json suffix, which will be ignored then")
    @GetMapping(value={"/v6/fileresources/identifier/**", "/v5/fileresources/identifier/**", "/v2/fileresources/identifier/**", "/latest/fileresources/identifier/**"}, produces={"application/json"})
    public ResponseEntity<FileResource> getByIdentifier(HttpServletRequest request) throws ServiceException, ValidationException {
        return super.getByIdentifier(request);
    }

    @Operation(summary="Get a fileresource by uuid")
    @GetMapping(value={"/v6/fileresources/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v5/fileresources/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v2/fileresources/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/latest/fileresources/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public ResponseEntity<FileResource> getByUuid(@Parameter(example="", description="UUID of the fileresource, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid, @Parameter(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale) throws ServiceException {
        if (pLocale == null) {
            return super.getByUuid(uuid);
        }
        return super.getByUuidAndLocale(uuid, pLocale);
    }

    @Operation(summary="Get languages of all websites")
    @GetMapping(value={"/v6/fileresources/languages", "/v5/fileresources/languages", "/v2/fileresources/languages", "/latest/fileresources/languages"}, produces={"application/json"})
    public List<Locale> getLanguages() throws ServiceException {
        return super.getLanguages();
    }

    protected IdentifiableService<FileResource> getService() {
        return this.service;
    }

    @Operation(summary="Save a newly created fileresource")
    @PostMapping(value={"/v6/fileresources", "/v5/fileresources", "/v2/fileresources", "/latest/fileresources"}, produces={"application/json"})
    public FileResource save(@RequestBody FileResource fileResource, BindingResult bindingResult) throws ServiceException, ValidationException {
        return (FileResource)super.save((UniqueObject)fileResource, bindingResult);
    }

    @Operation(summary="Update a fileresource")
    @PutMapping(value={"/v6/fileresources/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v5/fileresources/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v2/fileresources/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/latest/fileresources/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public FileResource update(@PathVariable UUID uuid, @RequestBody FileResource fileResource, BindingResult errors) throws ServiceException, ValidationException {
        return (FileResource)super.update(uuid, (UniqueObject)fileResource, errors);
    }
}

