/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.entity.work;

import de.digitalcollections.cudami.server.business.api.service.exceptions.ConflictException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.EntityService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.work.ItemService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.work.ManifestationService;
import de.digitalcollections.cudami.server.controller.AbstractEntityController;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.entity.item.Item;
import de.digitalcollections.model.identifiable.entity.manifestation.Manifestation;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Manifestation controller")
public class ManifestationController
extends AbstractEntityController<Manifestation> {
    private ItemService itemService;
    private ManifestationService service;

    public ManifestationController(ManifestationService manifestationService, ItemService itemService) {
        this.service = manifestationService;
        this.itemService = itemService;
    }

    @Operation(summary="Count all manifestations")
    @GetMapping(value={"/v6/manifestations/count"}, produces={"application/json"})
    public long count() throws ServiceException {
        return super.count();
    }

    @Operation(summary="Delete a manifestation")
    @DeleteMapping(value={"/v6/manifestations/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public ResponseEntity delete(@Parameter(example="", description="UUID of the manifestation") @PathVariable(value="uuid") UUID uuid) throws ConflictException, ServiceException {
        return super.delete(uuid);
    }

    @Operation(summary="Remove an existing parent manifestation from an existing manifestation")
    @DeleteMapping(value={"/v6/manifestations/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/parent/{parentManifestationUuid}"}, produces={"application/json"})
    public ResponseEntity removeParentManifestation(@Parameter(example="", description="UUID of the manifestation") @PathVariable(value="uuid") UUID uuid, @Parameter(example="", description="UUID of the parent manifestation") @PathVariable(value="parentManifestationUuid") UUID parentManifestationUuid) throws ServiceException {
        Manifestation parentManifestation;
        Manifestation manifestation = (Manifestation)this.buildExampleWithUuid(uuid);
        boolean successful = this.service.removeParent(manifestation, parentManifestation = (Manifestation)this.buildExampleWithUuid(parentManifestationUuid));
        return successful ? new ResponseEntity(HttpStatus.NO_CONTENT) : new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Get all manifestations as (paged, sorted, filtered) list")
    @GetMapping(value={"/v6/manifestations"}, produces={"application/json"})
    public PageResponse<Manifestation> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering) throws ServiceException {
        return super.find(pageNumber, pageSize, sortBy, filterCriteria, filtering);
    }

    @Operation(summary="Find all items of a manifestation")
    @GetMapping(value={"/v6/manifestations/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/items"}, produces={"application/json"})
    public PageResponse<Item> findItems(@Parameter(example="", description="UUID of the manifestation") @PathVariable(value="uuid") UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy) throws ServiceException {
        PageRequest pageRequest = new PageRequest(null, pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(sortBy);
            pageRequest.setSorting(sorting);
        }
        return this.itemService.findItemsByManifestation((Manifestation)this.buildExampleWithUuid(uuid), pageRequest);
    }

    @Operation(summary="Find all children of a manifestation")
    @GetMapping(value={"/v6/manifestations/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/children"}, produces={"application/json"})
    public PageResponse<Manifestation> findChildren(@Parameter(example="", description="UUID of the manifestation") @PathVariable(value="uuid") UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy) throws ServiceException {
        PageRequest pageRequest = new PageRequest(null, pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(sortBy);
            pageRequest.setSorting(sorting);
        }
        return this.service.findSubParts((Manifestation)this.buildExampleWithUuid(uuid), pageRequest);
    }

    @Operation(summary="Get a manifestation by namespace and id", description="Separate namespace and id with a colon, e.g. foo:bar. It is also possible, to add a .json suffix, which will be ignored then")
    @GetMapping(value={"/v6/manifestations/identifier/**"}, produces={"application/json"})
    public ResponseEntity<Manifestation> getByIdentifier(HttpServletRequest request) throws ServiceException, ValidationException {
        return super.getByIdentifier(request);
    }

    @Operation(summary="Get a manifestation by uuid")
    @GetMapping(value={"/v6/manifestations/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public ResponseEntity<Manifestation> getByUuid(@Parameter(name="uuid", description="UUID of the manifestation, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable UUID uuid, @Parameter(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale) throws ServiceException {
        if (pLocale == null) {
            return super.getByUuid(uuid);
        }
        return super.getByUuidAndLocale(uuid, pLocale);
    }

    @Operation(summary="Get a list of manifestations by UUID")
    @GetMapping(value={"/v6/manifestations/list/{uuids}"}, produces={"application/json"})
    public PageResponse<Manifestation> getByUuids(@PathVariable List<UUID> uuids) throws ServiceException {
        return super.getByUuids(uuids);
    }

    @Operation(summary="Get a list of manifestations by UUID")
    @PostMapping(value={"/v6/manifestations/list"}, produces={"application/json"})
    public PageResponse<Manifestation> getByManyUuids(@RequestBody List<UUID> uuids) throws ServiceException {
        return super.getByUuids(uuids);
    }

    @Operation(summary="Get languages of all manifestations")
    @GetMapping(value={"/v6/manifestations/languages"}, produces={"application/json"})
    public List<Locale> getLanguages() throws ServiceException {
        return super.getLanguages();
    }

    @Operation(summary="Get languages of all items", description="Get languages of all items", responses={@ApiResponse(responseCode="200", description="List&lt;Locale&gt;")})
    @GetMapping(value={"/v6/manifestations/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/items/languages"}, produces={"application/json"})
    public List<Locale> getLanguagesOfItems(@Parameter(name="uuid", description="UUID of the manifestation") @PathVariable UUID uuid) throws ServiceException {
        return this.itemService.getLanguagesOfItemsForManifestation((Manifestation)this.buildExampleWithUuid(uuid));
    }

    protected EntityService<Manifestation> getService() {
        return this.service;
    }

    @Operation(summary="Save a newly created manifestation")
    @PostMapping(value={"/v6/manifestations"}, produces={"application/json"})
    public Manifestation save(@RequestBody Manifestation manifestation, BindingResult errors) throws ServiceException, ValidationException {
        return (Manifestation)super.save((UniqueObject)manifestation, errors);
    }

    @Operation(summary="update an manifestation")
    @PutMapping(value={"/v6/manifestations/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public Manifestation update(@PathVariable UUID uuid, @RequestBody Manifestation manifestation, BindingResult errors) throws ServiceException, ValidationException {
        return (Manifestation)super.update(uuid, (UniqueObject)manifestation, errors);
    }
}

