/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.advice;

import de.digitalcollections.cudami.server.business.api.service.exceptions.ConflictException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ResourceNotFoundException;
import de.digitalcollections.model.validation.ValidationException;
import java.util.Date;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class ExceptionAdvice {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionAdvice.class);

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public void handleAllOther(Exception exception) {
        LOGGER.error("exception stack trace", (Throwable)exception);
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={ConflictException.class})
    public void handleConflict(ConflictException exception) {
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    public void handleHttpMediaTypeNotAcceptableException() {
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={ResourceNotFoundException.class, UsernameNotFoundException.class})
    public void handleNotFound() {
    }

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity<Object> handleValidationException(ValidationException exception) {
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>(2);
        body.put("timestamp", new Date());
        body.put("errors", exception.getErrors());
        return new ResponseEntity(body, HttpStatus.UNPROCESSABLE_ENTITY);
    }
}

