/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.entity.geo.location;

import de.digitalcollections.cudami.server.business.api.service.exceptions.ConflictException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.EntityService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.geo.location.HumanSettlementService;
import de.digitalcollections.cudami.server.controller.AbstractEntityController;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.entity.geo.location.HumanSettlement;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Human settlement controller")
public class HumanSettlementController
extends AbstractEntityController<HumanSettlement> {
    private final HumanSettlementService service;

    public HumanSettlementController(HumanSettlementService humanSettlementService) {
        this.service = humanSettlementService;
    }

    @Operation(summary="Delete a human settlement")
    @DeleteMapping(value={"/v6/humansettlements/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public ResponseEntity delete(@Parameter(example="", description="UUID of the human settlement") @PathVariable(value="uuid") UUID uuid) throws ConflictException, ServiceException {
        return super.delete(uuid);
    }

    @Operation(summary="Get all human settlements as (paged, sorted, filtered) list")
    @GetMapping(value={"/v6/humansettlements"}, produces={"application/json"})
    public PageResponse<HumanSettlement> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering) throws ServiceException {
        return super.find(pageNumber, pageSize, sortBy, filterCriteria, filtering);
    }

    @Operation(summary="Get a geolocation by namespace and id", description="Separate namespace and id with a colon, e.g. foo:bar. It is also possible, to add a .json suffix, which will be ignored then")
    @GetMapping(value={"/v6/humansettlements/identifier/**", "/v5/humansettlements/identifier/**", "/v2/humansettlements/identifier/**", "/latest/humansettlements/identifier/**"}, produces={"application/json"})
    public ResponseEntity<HumanSettlement> getByIdentifier(HttpServletRequest request) throws ServiceException, ValidationException {
        return super.getByIdentifier(request);
    }

    @Operation(summary="Get a human settlement by namespace and id")
    @GetMapping(value={"/v6/humansettlements/identifier", "/v5/humansettlements/identifier", "/v2/humansettlements/identifier", "/latest/humansettlements/identifier"}, produces={"application/json"})
    public ResponseEntity<Void> getByIdentifier(@RequestParam(name="namespace", required=true) String namespace, @RequestParam(name="id", required=true) String id, HttpServletRequest request) throws ServiceException {
        URI newLocation = URI.create(request.getRequestURI().concat(String.format("/%s:%s", namespace, id)));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.MOVED_PERMANENTLY).location(newLocation)).build();
    }

    @Operation(summary="Get a human settlement by uuid")
    @GetMapping(value={"/v6/humansettlements/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v5/humansettlements/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v2/humansettlements/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/latest/humansettlements/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public ResponseEntity<HumanSettlement> getByUuid(@Parameter(example="", description="UUID of the human settlement, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid, @Parameter(name="pLocale", description="Desired locale, e.g. <tt>de</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale) throws ServiceException {
        if (pLocale == null) {
            return this.getByUuid(uuid);
        }
        return this.getByUuidAndLocale(uuid, pLocale);
    }

    protected EntityService<HumanSettlement> getService() {
        return this.service;
    }

    @Operation(summary="save a newly created human settlement")
    @PostMapping(value={"/v6/humansettlements", "/v5/humansettlements", "/v2/humansettlements", "/latest/humansettlements"}, produces={"application/json"})
    public HumanSettlement save(@RequestBody HumanSettlement humanSettlement, BindingResult errors) throws ServiceException, ValidationException {
        return (HumanSettlement)super.save((UniqueObject)humanSettlement, errors);
    }

    @Operation(summary="update a human settlement")
    @PutMapping(value={"/v6/humansettlements/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v5/humansettlements/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v2/humansettlements/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/latest/humansettlements/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public HumanSettlement update(@PathVariable(value="uuid") UUID uuid, @RequestBody HumanSettlement humanSettlement, BindingResult errors) throws ServiceException, ValidationException {
        return (HumanSettlement)super.update(uuid, (UniqueObject)humanSettlement, errors);
    }
}

