/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.entity;

import de.digitalcollections.cudami.server.business.api.service.exceptions.ConflictException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.DigitalObjectService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.EntityService;
import de.digitalcollections.cudami.server.controller.AbstractEntityController;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.Project;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.identifiable.entity.item.Item;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.FilterOperation;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@Tag(name="Digital object controller")
public class DigitalObjectController
extends AbstractEntityController<DigitalObject> {
    private final DigitalObjectService service;

    public DigitalObjectController(DigitalObjectService digitalObjectService) {
        this.service = digitalObjectService;
    }

    @Operation(summary="Get count of digital objects")
    @GetMapping(value={"/v6/digitalobjects/count", "/v5/digitalobjects/count", "/v2/digitalobjects/count", "/latest/digitalobjects/count"}, produces={"application/json"})
    public long count() throws ServiceException {
        return super.count();
    }

    @Operation(summary="Delete a digital object with all its relations")
    @DeleteMapping(value={"/v6/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v5/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v2/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/latest/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public ResponseEntity delete(@Parameter(example="", description="UUID of the digital object") @PathVariable(value="uuid") UUID uuid) throws ConflictException, ServiceException {
        return super.delete(uuid);
    }

    @Operation(summary="Get all digital objects as (paged, sorted, filtered) list")
    @GetMapping(value={"/v6/digitalobjects"}, produces={"application/json"})
    public PageResponse<DigitalObject> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering) throws ServiceException {
        return super.find(pageNumber, pageSize, sortBy, filterCriteria, filtering);
    }

    @Operation(summary="Get all projects of a digital object as (paged, sorted, filtered) list")
    @GetMapping(value={"/v6/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/projects"}, produces={"application/json"})
    public PageResponse<Project> findProjects(@Parameter(example="", description="UUID of the digital object") @PathVariable(value="uuid") UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering) throws ServiceException {
        PageRequest pageRequest = this.createPageRequest(Project.class, pageNumber, pageSize, sortBy, filterCriteria, filtering);
        return this.service.findProjects((DigitalObject)this.buildExampleWithUuid(uuid), pageRequest);
    }

    @Operation(summary="Get a digital object by namespace and id", description="Separate namespace and id with a colon, e.g. foo:bar. It is also possible, to add a .json suffix, which will be ignored then")
    @GetMapping(value={"/v6/digitalobjects/identifier/**", "/v5/digitalobjects/identifier/**", "/v2/digitalobjects/identifier/**", "/latest/digitalobjects/identifier/**"}, produces={"application/json"})
    public ResponseEntity<DigitalObject> getByIdentifier(HttpServletRequest request, @RequestParam(name="fill-wemi", required=false, defaultValue="false") boolean fillWemi) throws ServiceException, ValidationException {
        Pair namespaceAndId = DigitalObjectController.extractNamespaceAndId((HttpServletRequest)request);
        Identifier identifier = (Identifier)Identifier.builder().namespace((String)namespaceAndId.getLeft()).id((String)namespaceAndId.getRight()).build();
        DigitalObject digitalObject = fillWemi ? this.service.getByIdentifierWithWEMI(identifier) : (DigitalObject)this.service.getByIdentifier(identifier);
        return new ResponseEntity((Object)digitalObject, digitalObject != null ? HttpStatus.OK : HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Get a digital object by refId")
    @GetMapping(value={"/v5/digitalobjects/{refId:[0-9]+}"}, produces={"application/json"})
    public ResponseEntity<DigitalObject> getByRefId(@PathVariable long refId) throws ServiceException {
        return super.getByRefId(refId);
    }

    @Operation(summary="Get a digital object by uuid")
    @GetMapping(value={"/v6/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v5/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v2/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/latest/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public ResponseEntity<DigitalObject> getByUuid(@PathVariable UUID uuid) throws ServiceException {
        return super.getByUuid(uuid);
    }

    @Operation(summary="Get all (active) collections of a digital object as (paged, sorted, filtered) list")
    @GetMapping(value={"/v6/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/collections"}, produces={"application/json"})
    public PageResponse<Collection> getCollections(@Parameter(example="", description="UUID of the digital object") @PathVariable(value="uuid") UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering, @RequestParam(name="active", required=false) String active) throws ServiceException {
        PageRequest pageRequest = this.createPageRequest(Collection.class, pageNumber, pageSize, sortBy, filterCriteria, filtering);
        DigitalObject example = (DigitalObject)this.buildExampleWithUuid(uuid);
        if (active != null) {
            return this.service.findActiveCollections(example, pageRequest);
        }
        return this.service.findCollections(example, pageRequest);
    }

    @Operation(summary="Get file resources of a digital object")
    @GetMapping(value={"/v6/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/fileresources", "/v5/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/fileresources", "/v2/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/fileresources", "/latest/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/fileresources"}, produces={"application/json"})
    public List<FileResource> getFileResources(@PathVariable UUID uuid) throws ServiceException {
        return this.service.getFileResources((DigitalObject)this.buildExampleWithUuid(uuid));
    }

    @Operation(summary="Get IIIF image file resources of a digital object")
    @GetMapping(value={"/v6/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/fileresources/images/iiif"}, produces={"application/json"})
    public List<ImageFileResource> getIiifImageFileResources(@PathVariable UUID uuid) throws ServiceException {
        return this.service.getIiifImageFileResources((DigitalObject)this.buildExampleWithUuid(uuid));
    }

    @Operation(summary="Get image file resources of a digital object")
    @GetMapping(value={"/v6/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/fileresources/images", "/v5/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/fileresources/images", "/v2/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/fileresources/images", "/latest/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/fileresources/images"}, produces={"application/json"})
    public List<ImageFileResource> getImageFileResources(@PathVariable UUID uuid) throws ServiceException {
        return this.service.getImageFileResources((DigitalObject)this.buildExampleWithUuid(uuid));
    }

    @Operation(summary="Get item for digital object by digital object uuid")
    @GetMapping(value={"/v6/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/item", "/v5/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/item", "/v2/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/item", "/latest/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/item"}, produces={"application/json"})
    public Item getItem(@PathVariable UUID uuid) throws ServiceException {
        return this.service.getItem((DigitalObject)this.buildExampleWithUuid(uuid));
    }

    @Operation(summary="Get languages of all digital objects")
    @GetMapping(value={"/v6/digitalobjects/languages", "/v5/digitalobjects/languages", "/v3/digitalobjects/languages", "/latest/digitalobjects/languages"}, produces={"application/json"})
    public List<Locale> getLanguages(@RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering) throws ServiceException {
        Optional<FilterCriterion> parentUuidCriterion;
        if ((filterCriteria != null || filtering != null) && (parentUuidCriterion = Stream.concat(filterCriteria != null ? filterCriteria.stream() : Stream.empty(), filtering != null ? filtering.stream() : Stream.empty()).filter(p -> "parent.uuid".equals(p.getExpression()) && p.getOperation() == FilterOperation.EQUALS).findAny()).isPresent()) {
            return this.service.getLanguagesOfContainedDigitalObjects((DigitalObject)this.buildExampleWithUuid(UUID.fromString((String)parentUuidCriterion.get().getValue())));
        }
        return super.getLanguages();
    }

    @Operation(summary="Get all languages of a digital object's collections")
    @GetMapping(value={"/v6/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/collections/languages", "/v5/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/collections/languages"}, produces={"application/json"})
    public List<Locale> getLanguagesOfCollections(@PathVariable UUID uuid) throws ServiceException {
        return this.service.getLanguagesOfCollections((DigitalObject)this.buildExampleWithUuid(uuid));
    }

    @Operation(summary="Get all languages of a digital object's projects")
    @GetMapping(value={"/v6/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/projects/languages", "/v5/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/projects/languages"}, produces={"application/json"})
    public List<Locale> getLanguagesOfProjects(@PathVariable UUID uuid) throws ServiceException {
        return this.service.getLanguagesOfProjects((DigitalObject)this.buildExampleWithUuid(uuid));
    }

    @Operation(summary="Find limited amount of random digital objects")
    @GetMapping(value={"/v6/digitalobjects/random", "/v5/digitalobjects/random", "/v2/digitalobjects/random", "/latest/digitalobjects/random"}, produces={"application/json"})
    public List<DigitalObject> getRandomDigitalObjects(@RequestParam(name="count", required=false, defaultValue="5") int count) throws ServiceException {
        return this.service.getRandom(count);
    }

    protected EntityService<DigitalObject> getService() {
        return this.service;
    }

    @Operation(summary="Save a newly created digital object")
    @PostMapping(value={"/v6/digitalobjects", "/v5/digitalobjects", "/v2/digitalobjects", "/latest/digitalobjects"}, produces={"application/json"})
    public DigitalObject save(@RequestBody DigitalObject digitalObject, BindingResult errors) throws ServiceException, ValidationException {
        return (DigitalObject)super.save((UniqueObject)digitalObject, errors);
    }

    @Operation(summary="Save list of fileresources for a given digital object")
    @PostMapping(value={"/v6/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/fileresources", "/v5/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/fileresources", "/v3/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/fileresources", "/latest/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/fileresources"}, produces={"application/json"})
    public List<FileResource> setFileResources(@Parameter(example="", description="UUID of the digital object") @PathVariable(value="uuid") UUID uuid, @RequestBody List<FileResource> fileResources) throws ServiceException {
        return this.service.setFileResources((DigitalObject)this.buildExampleWithUuid(uuid), fileResources);
    }

    @Operation(summary="Update a digital object")
    @PutMapping(value={"/v6/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v5/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v2/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/latest/digitalobjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public DigitalObject update(@Parameter(example="", description="UUID of the digital object") @PathVariable(value="uuid") UUID uuid, @RequestBody DigitalObject digitalObject, BindingResult errors) throws ServiceException, ValidationException {
        return (DigitalObject)super.update(uuid, (UniqueObject)digitalObject, errors);
    }
}

