/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.entity;

import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ConflictException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.CollectionService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.EntityService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.agent.CorporateBodyService;
import de.digitalcollections.cudami.server.controller.AbstractEntityController;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.list.filtering.FilterCriteria;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.FilterLogicalOperator;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Collection controller")
public class CollectionController
extends AbstractEntityController<Collection> {
    private final LocaleService localeService;
    private final CollectionService service;
    private final CorporateBodyService corporateBodyService;

    public CollectionController(CollectionService collectionService, LocaleService localeService, CorporateBodyService corporateBodyService) {
        this.service = collectionService;
        this.localeService = localeService;
        this.corporateBodyService = corporateBodyService;
    }

    @Operation(summary="Add an existing digital object to an existing collection")
    @PostMapping(value={"/v6/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects/{digitalObjectUuid}", "/v5/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects/{digitalObjectUuid}", "/v3/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects/{digitalObjectUuid}", "/latest/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects/{digitalObjectUuid}"}, produces={"application/json"})
    public ResponseEntity addDigitalObject(@Parameter(example="", description="UUID of the collection") @PathVariable(value="uuid") UUID collectionUuid, @Parameter(example="", description="UUID of the digital object") @PathVariable(value="digitalObjectUuid") UUID digitalObjectUuid) throws ServiceException {
        Collection collection = new Collection();
        collection.setUuid(collectionUuid);
        DigitalObject digitalObject = new DigitalObject();
        digitalObject.setUuid(digitalObjectUuid);
        boolean successful = this.service.addDigitalObject(collection, digitalObject);
        return successful ? new ResponseEntity(HttpStatus.NO_CONTENT) : new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Add existing digital objects to an existing collection")
    @PostMapping(value={"/v6/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects", "/v5/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects", "/v3/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects", "/latest/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects"}, produces={"application/json"})
    public ResponseEntity addDigitalObjects(@Parameter(example="", description="UUID of the collection") @PathVariable(value="uuid") UUID collectionUuid, @Parameter(example="", description="List of the digital objects") @RequestBody List<DigitalObject> digitalObjects) throws ServiceException {
        Collection collection = new Collection();
        collection.setUuid(collectionUuid);
        boolean successful = this.service.addDigitalObjects(collection, digitalObjects);
        return successful ? new ResponseEntity(HttpStatus.NO_CONTENT) : new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Add an existing collection to an existing collection")
    @PostMapping(value={"/v6/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/subcollections/{subcollectionUuid}", "/v5/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/subcollections/{subcollectionUuid}", "/v3/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/subcollections/{subcollectionUuid}", "/latest/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/subcollections/{subcollectionUuid}"}, produces={"application/json"})
    public ResponseEntity addSubcollection(@Parameter(example="", description="UUID of the collection") @PathVariable(value="uuid") UUID uuid, @Parameter(example="", description="UUID of the subcollection") @PathVariable(value="subcollectionUuid") UUID subcollectionUuid) throws ServiceException {
        Collection collection = new Collection();
        collection.setUuid(uuid);
        Collection subcollection = new Collection();
        subcollection.setUuid(subcollectionUuid);
        boolean successful = this.service.addChild((Identifiable)collection, (Identifiable)subcollection);
        return successful ? new ResponseEntity(HttpStatus.NO_CONTENT) : new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Add existing collections to an existing collection")
    @PostMapping(value={"/v6/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/subcollections", "/v5/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/subcollections", "/v3/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/subcollections", "/latest/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/subcollections"}, produces={"application/json"})
    public ResponseEntity addSubcollections(@Parameter(example="", description="UUID of the collection") @PathVariable(value="uuid") UUID uuid, @Parameter(example="", description="List of the subcollections") @RequestBody List<Collection> subcollections) throws ServiceException {
        Collection collection = new Collection();
        collection.setUuid(uuid);
        boolean successful = this.service.addChildren((Identifiable)collection, subcollections);
        return successful ? new ResponseEntity(HttpStatus.NO_CONTENT) : new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Get count of collections")
    @GetMapping(value={"/v6/collections/count", "/v5/collections/count", "/v2/collections/count", "/latest/collections/count"}, produces={"application/json"})
    public long count() throws ServiceException {
        return super.count();
    }

    @Operation(summary="Delete an existing collection")
    @DeleteMapping(value={"/v6/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public ResponseEntity delete(@Parameter(example="", description="UUID of the collection") @PathVariable(value="uuid") UUID uuid) throws ConflictException, ServiceException {
        return super.delete(uuid);
    }

    @Operation(summary="Get (active or all) collections as (paged, sorted, filtered) list")
    @GetMapping(value={"/v6/collections"}, produces={"application/json"})
    public PageResponse<Collection> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering, @RequestParam(name="active", required=false) String active) throws ServiceException {
        if (active != null) {
            PageRequest pageRequest = this.createPageRequest(Collection.class, pageNumber, pageSize, sortBy, filterCriteria, filtering);
            return this.service.findActive(pageRequest);
        }
        return super.find(pageNumber, pageSize, sortBy, filterCriteria, filtering);
    }

    @Operation(summary="Get all digital objects of a collection as (paged, sorted, filtered) list")
    @GetMapping(value={"/v6/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects"}, produces={"application/json"})
    public PageResponse<DigitalObject> findDigitalObjects(@Parameter(example="", description="UUID of the collection") @PathVariable(value="uuid") UUID collectionUuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering) throws ServiceException {
        PageRequest pageRequest = this.createPageRequest(DigitalObject.class, pageNumber, pageSize, null, filterCriteria, filtering);
        Collection collection = new Collection();
        collection.setUuid(collectionUuid);
        return this.service.findDigitalObjects(collection, pageRequest);
    }

    @Operation(summary="Get all related - by the given predicate - corporate bodies of a collection")
    @GetMapping(value={"/v6/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/related/corporatebodies", "/v5/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/related/corporatebodies", "/v3/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/related/corporatebodies", "/latest/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/related/corporatebodies"}, produces={"application/json"})
    public List<CorporateBody> findRelatedCorporateBodies(@Parameter(example="", description="UUID of the collection") @PathVariable(value="uuid") UUID uuid, @RequestParam(name="predicate", required=false) FilterCriterion predicateFilter, @RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering) throws ServiceException {
        FilterCriterion predicateFromFiltering;
        FilterCriteria predicateFca = filtering != null ? filtering.getFilterCriteriaListFor("predicate") : null;
        FilterCriterion filterCriterion = predicateFromFiltering = predicateFca != null ? predicateFca.getFilterCriterionFor("predicate") : null;
        if (predicateFromFiltering != null) {
            predicateFca.remove((Object)predicateFromFiltering);
        }
        Filtering resultingFiltering = this.mergeFilters(CorporateBody.class, filtering, filterCriteria);
        if (predicateFromFiltering != null) {
            if (resultingFiltering == null) {
                resultingFiltering = new Filtering();
            }
            resultingFiltering.add(FilterLogicalOperator.AND, List.of(predicateFromFiltering));
        } else if (predicateFilter != null) {
            if (resultingFiltering == null) {
                resultingFiltering = new Filtering();
            }
            predicateFilter.setExpression("predicate");
            resultingFiltering.add(FilterLogicalOperator.AND, List.of(predicateFilter));
        }
        return this.corporateBodyService.findCollectionRelatedCorporateBodies((Collection)this.buildExampleWithUuid(uuid), resultingFiltering);
    }

    @Operation(summary="Get all (active) subcollections of a collection as (paged, sorted, filtered) list")
    @GetMapping(value={"/v6/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/subcollections"}, produces={"application/json"})
    public PageResponse<Collection> findSubcollections(@Parameter(example="", description="UUID of the collection") @PathVariable(value="uuid") UUID collectionUuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering, @RequestParam(name="active", required=false) String active) throws ServiceException {
        PageRequest pageRequest = this.createPageRequest(Collection.class, pageNumber, pageSize, sortBy, filterCriteria, filtering);
        if (active != null) {
            return this.service.findActiveChildren((Collection)this.buildExampleWithUuid(collectionUuid), pageRequest);
        }
        return this.service.findChildren((Identifiable)((Collection)this.buildExampleWithUuid(collectionUuid)), pageRequest);
    }

    @Operation(summary="Get all (active) top collections as (paged, sorted, filtered) list")
    @GetMapping(value={"/v6/collections/top"}, produces={"application/json"})
    public PageResponse<Collection> findTopCollections(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="filter", required=false) List<FilterCriterion> filterCriteria, @RequestParam(name="filtering", required=false) Filtering filtering, @RequestParam(name="active", required=false) String active) throws ServiceException {
        PageRequest pageRequest = this.createPageRequest(Collection.class, pageNumber, pageSize, sortBy, filterCriteria, filtering);
        return this.service.findRootNodes(pageRequest);
    }

    @Operation(summary="Get the breadcrumb for a collection")
    @GetMapping(value={"/v6/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/breadcrumb", "/v5/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/breadcrumb", "/v3/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/breadcrumb", "/latest/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/breadcrumb"}, produces={"application/json"})
    public ResponseEntity<BreadcrumbNavigation> getBreadcrumbNavigation(@Parameter(example="", description="UUID of the collection, e.g. <tt>6119d8e9-9c92-4091-8dcb-bc4053385406</tt>") @PathVariable(value="uuid") UUID uuid, @Parameter(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale) throws ServiceException {
        BreadcrumbNavigation breadcrumbNavigation = pLocale == null ? this.service.getBreadcrumbNavigation((Identifiable)((Collection)this.buildExampleWithUuid(uuid))) : this.service.getBreadcrumbNavigation((Identifiable)((Collection)this.buildExampleWithUuid(uuid)), pLocale, this.localeService.getDefaultLocale());
        if (breadcrumbNavigation == null || breadcrumbNavigation.getNavigationItems().isEmpty()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)breadcrumbNavigation, HttpStatus.OK);
    }

    @Operation(summary="Get a collection by namespace and id", description="Separate namespace and id with a colon, e.g. foo:bar. It is also possible, to add a .json suffix, which will be ignored then")
    @GetMapping(value={"/v6/collections/identifier/**", "/v5/collections/identifier/**", "/v2/collections/identifier/**", "/latest/collections/identifier/**"}, produces={"application/json"})
    public ResponseEntity<Collection> getByIdentifier(HttpServletRequest request) throws ServiceException, ValidationException {
        return super.getByIdentifier(request);
    }

    @Operation(summary="Get a collection by refId")
    @GetMapping(value={"/v6/collections/{refId:[0-9]+}", "/v5/collections/{refId:[0-9]+}", "/latest/collections/{refId:[0-9]+}"}, produces={"application/json"})
    public ResponseEntity<Collection> getByRefId(@Parameter(example="", description="refId of the collection, e.g. <tt>42</tt>") @PathVariable long refId) throws ServiceException {
        return super.getByRefId(refId);
    }

    @Operation(summary="Get a collection by uuid")
    @GetMapping(value={"/v6/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v5/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v2/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/latest/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public ResponseEntity<Collection> getByUuid(@Parameter(example="", description="UUID of the collection, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid, @Parameter(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale, @Parameter(name="active", description="If set, object will only be returned if active") @RequestParam(name="active", required=false) String active) throws ServiceException {
        Collection example = (Collection)this.buildExampleWithUuid(uuid);
        Collection collection = active != null ? (pLocale == null ? this.service.getByExampleAndActive(example) : this.service.getByExampleAndActiveAndLocale(example, pLocale)) : (pLocale == null ? (Collection)this.service.getByExample((UniqueObject)example) : (Collection)this.service.getByExampleAndLocale((Identifiable)example, pLocale));
        return new ResponseEntity((Object)collection, collection != null ? HttpStatus.OK : HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Get the first created parent of a collection")
    @GetMapping(value={"/v6/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/parent", "/v5/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/parent", "/v3/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/parent", "/latest/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/parent"}, produces={"application/json"})
    public Collection getParent(@PathVariable UUID uuid) throws ServiceException {
        return (Collection)this.service.getParent((Identifiable)((Collection)this.buildExampleWithUuid(uuid)));
    }

    @Operation(summary="Get parent collections")
    @GetMapping(value={"/v6/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/parents", "/v5/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/parents", "/v3/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/parents", "/latest/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/parents"}, produces={"application/json"})
    public List<Collection> getParents(@Parameter(example="", description="UUID of the collection") @PathVariable(value="uuid") UUID collectionUuid) throws ServiceException {
        return this.service.getParents((Identifiable)((Collection)this.buildExampleWithUuid(collectionUuid)));
    }

    protected EntityService<Collection> getService() {
        return this.service;
    }

    @Operation(summary="Get languages of all top collections")
    @GetMapping(value={"/v6/collections/top/languages", "/v5/collections/top/languages", "/v2/collections/top/languages", "/latest/collections/top/languages"}, produces={"application/json"})
    public List<Locale> getTopCollectionsLanguages() throws ServiceException {
        return this.service.getRootNodesLanguages();
    }

    @Operation(summary="Remove an existing digital object from an existing collection")
    @DeleteMapping(value={"/v6/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects/{digitalObjectUuid}", "/v5/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects/{digitalObjectUuid}", "/v3/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects/{digitalObjectUuid}", "/latest/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects/{digitalObjectUuid}"}, produces={"application/json"})
    public ResponseEntity removeDigitalObject(@Parameter(example="", description="UUID of the collection") @PathVariable(value="uuid") UUID collectionUuid, @Parameter(example="", description="UUID of the digital object") @PathVariable(value="digitalObjectUuid") UUID digitalObjectUuid) throws ServiceException {
        Collection collection = new Collection();
        collection.setUuid(collectionUuid);
        DigitalObject digitalObject = new DigitalObject();
        digitalObject.setUuid(digitalObjectUuid);
        boolean successful = this.service.removeDigitalObject(collection, digitalObject);
        return successful ? new ResponseEntity(HttpStatus.NO_CONTENT) : new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Remove an existing collection from an existing collection")
    @DeleteMapping(value={"/v6/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/subcollections/{subcollectionUuid}", "/v5/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/subcollections/{subcollectionUuid}", "/v3/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/subcollections/{subcollectionUuid}", "/latest/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/subcollections/{subcollectionUuid}"}, produces={"application/json"})
    public ResponseEntity removeSubcollection(@Parameter(example="", description="UUID of the collection") @PathVariable(value="uuid") UUID uuid, @Parameter(example="", description="UUID of the subcollection") @PathVariable(value="subcollectionUuid") UUID subcollectionUuid) throws ServiceException {
        Collection collection = new Collection();
        collection.setUuid(uuid);
        Collection subcollection = new Collection();
        subcollection.setUuid(subcollectionUuid);
        boolean successful = this.service.removeChild((Identifiable)collection, (Identifiable)subcollection);
        return successful ? new ResponseEntity(HttpStatus.NO_CONTENT) : new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Save a newly created collection")
    @PostMapping(value={"/v6/collections", "/v5/collections", "/v2/collections", "/latest/collections"}, produces={"application/json"})
    public Collection save(@RequestBody Collection collection, BindingResult errors) throws ServiceException, ValidationException {
        return (Collection)super.save((UniqueObject)collection, errors);
    }

    @Operation(summary="Save existing digital objects into an existing collection")
    @PutMapping(value={"/v6/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects", "/v5/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects", "/v3/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects", "/latest/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects"}, produces={"application/json"})
    public ResponseEntity saveDigitalObjects(@Parameter(example="", description="UUID of the collection") @PathVariable(value="uuid") UUID collectionUuid, @Parameter(example="", description="List of the digital objects") @RequestBody List<DigitalObject> digitalObjects) throws ServiceException {
        boolean successful = this.service.setDigitalObjects((Collection)this.buildExampleWithUuid(collectionUuid), digitalObjects);
        return successful ? new ResponseEntity(HttpStatus.NO_CONTENT) : new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @Operation(summary="Save a newly created collection with parent collection")
    @PostMapping(value={"/v6/collections/{parentUuid}/collection", "/v5/collections/{parentUuid}/collection", "/v2/collections/{parentUuid}/collection", "/latest/collections/{parentUuid}/collection"}, produces={"application/json"})
    public Collection saveWithParentCollection(@Parameter(name="parentUuid", description="The uuid of the parent collection") @PathVariable UUID parentUuid, @RequestBody Collection collection) throws ServiceException, ValidationException {
        return (Collection)this.service.saveWithParent((Identifiable)collection, (Identifiable)((Collection)this.buildExampleWithUuid(parentUuid)));
    }

    @Operation(summary="Update a collection")
    @PutMapping(value={"/v6/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v5/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/v2/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}", "/latest/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"}, produces={"application/json"})
    public Collection update(@PathVariable UUID uuid, @RequestBody Collection collection, BindingResult errors) throws ServiceException, ValidationException {
        return (Collection)super.update(uuid, (UniqueObject)collection, errors);
    }
}

