/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifierTypeService;
import de.digitalcollections.cudami.server.controller.legacy.V5MigrationHelper;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Identifier type controller")
public class V2IdentifierTypeController {
    private final ObjectMapper objectMapper;
    private final IdentifierTypeService identifierTypeService;

    public V2IdentifierTypeController(IdentifierTypeService identifierTypeService, ObjectMapper objectMapper) {
        this.identifierTypeService = identifierTypeService;
        this.objectMapper = objectMapper;
    }

    @Operation(summary="Get all identifier types", description="Get a paged and sorted list of all identifier types", responses={@ApiResponse(responseCode="200", description="PageResponse&lt;IdentifierType&gt; (<a href=\"https://raw.githubusercontent.com/dbmdz/digitalcollections-model/8.2.1/dc-model/src/main/java/de/digitalcollections/model/api/paging/PageResponse.java\">dc-model &lt; 9.0</a>)", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class), examples={@ExampleObject(name="example list", externalValue="https://github.com/dbmdz/cudami/raw/main/dc-cudami-server/dc-cudami-server-webapp/src/test/resources/json/v2/identifiertypes/identifiertypes.json")})})})
    @GetMapping(value={"/v2/identifiertypes", "/latest/identifiertypes"}, produces={"application/json"})
    public ResponseEntity<String> find(@Parameter(name="pageNumber", description="the page number (starting with 0); if unset, defaults to 0.", example="0", schema=@Schema(type="integer")) @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @Parameter(name="pageSize", description="the page size; if unset, defaults to 25", example="25", schema=@Schema(type="integer")) @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @Parameter(name="sortBy", description="the sorting specification; if unset, default to alphabetically ascending sorting of the field 'label')", example="label_de.desc.nullsfirst", schema=@Schema(type="string")) @RequestParam(name="sortBy", required=false) List<Order> sortBy) throws JsonProcessingException {
        PageRequest pageRequest = new PageRequest(pageNumber, pageSize);
        if (sortBy != null) {
            List migratedSortBy = V5MigrationHelper.migrate(sortBy);
            Sorting sorting = new Sorting(migratedSortBy);
            pageRequest.setSorting(sorting);
        }
        PageResponse response = this.identifierTypeService.find(pageRequest);
        JSONObject result = new JSONObject(this.objectMapper.writeValueAsString((Object)response));
        JSONArray digitalobjects = (JSONArray)result.get("content");
        for (JSONObject digitalobject : digitalobjects) {
            digitalobject.put("className", (Object)"de.digitalcollections.model.impl.identifiable.IdentifierTypeImpl");
        }
        return new ResponseEntity((Object)result.toString(), HttpStatus.OK);
    }
}

