/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.entity;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.HeadwordEntryService;
import de.digitalcollections.cudami.server.controller.CudamiControllerException;
import de.digitalcollections.cudami.server.controller.legacy.V5MigrationHelper;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="V5b HeadwordEntry controller")
public class V5HeadwordEntryController {
    private final HeadwordEntryService headwordEntryService;
    private final ObjectMapper objectMapper;

    public V5HeadwordEntryController(HeadwordEntryService headwordEntryService, ObjectMapper objectMapper) {
        this.headwordEntryService = headwordEntryService;
        this.objectMapper = objectMapper;
    }

    @Operation(summary="Get all headwordentries")
    @GetMapping(value={"/v5/headwordentries"}, produces={"application/json"})
    public ResponseEntity<String> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortBy", required=false) List<Order> sortBy, @RequestParam(name="searchTerm", required=false) String searchTerm) throws CudamiControllerException {
        PageRequest pageRequest = new PageRequest(searchTerm, pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(V5MigrationHelper.migrate(sortBy));
            pageRequest.setSorting(sorting);
        }
        PageResponse pageResponse = this.headwordEntryService.find(pageRequest);
        try {
            String result = V5MigrationHelper.migrate((PageResponse)pageResponse, (ObjectMapper)this.objectMapper);
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (JsonProcessingException e) {
            throw new CudamiControllerException((Throwable)e);
        }
    }
}

