/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable;

import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifiableService;
import de.digitalcollections.cudami.server.controller.ParameterHelper;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.FilterOperation;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public abstract class AbstractIdentifiableController<T extends Identifiable> {
    public ResponseEntity<T> getByIdentifier(HttpServletRequest request) throws IdentifiableServiceException, ValidationException {
        Identifiable identifiable;
        Pair namespaceAndId = ParameterHelper.extractPairOfStringsFromUri((String)request.getRequestURI(), (String)"^.*?/identifier/");
        if (((String)namespaceAndId.getLeft()).isBlank() || namespaceAndId.getRight() == null || ((String)namespaceAndId.getRight()).isBlank()) {
            throw new ValidationException("No namespace and/or id were provided in a colon separated manner");
        }
        return new ResponseEntity((Object)identifiable, (identifiable = this.getService().getByIdentifier((String)namespaceAndId.getLeft(), (String)namespaceAndId.getRight())) != null ? HttpStatus.OK : HttpStatus.NOT_FOUND);
    }

    protected PageResponse<T> find(int pageNumber, int pageSize, List<Order> sortBy, String searchTerm, String labelTerm, Locale labelLanguage, Object ... filterCriteria) {
        PageRequest pageRequest = new PageRequest(searchTerm, pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(sortBy);
            pageRequest.setSorting(sorting);
        }
        if (filterCriteria.length > 0 && filterCriteria.length % 2 == 0) {
            for (int i = 0; i < filterCriteria.length; i += 2) {
                if (filterCriteria[i + 1] == null) continue;
                if (!(filterCriteria[i] instanceof String) || !(filterCriteria[i + 1] instanceof FilterCriterion)) {
                    throw new IllegalArgumentException("`filterCriteria` must be pairs of a `String`, the expression, and the corresponding `FilterCriterion`");
                }
                String expression = (String)filterCriteria[i];
                FilterCriterion criterion = (FilterCriterion)filterCriteria[i + 1];
                criterion.setExpression(expression);
                pageRequest.add(new Filtering(List.of(criterion)));
            }
        }
        this.addLabelFilter(pageRequest, labelTerm, labelLanguage);
        return this.getService().find(pageRequest);
    }

    protected abstract IdentifiableService<T> getService();

    protected void addLabelFilter(PageRequest pageRequest, String labelTerm, Locale labelLanguage) {
        if (pageRequest == null || labelTerm == null) {
            return;
        }
        labelTerm = labelTerm.trim();
        Object expression = "label";
        if (labelLanguage != null) {
            expression = (String)expression + "." + labelLanguage.getLanguage();
        }
        FilterOperation operation = FilterOperation.CONTAINS;
        if (labelTerm.matches("\".+\"")) {
            operation = FilterOperation.EQUALS;
        }
        pageRequest.add(Filtering.builder().add(new FilterCriterion((String)expression, operation, (Object)labelTerm)).build());
    }
}

