/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.legacy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.Order;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class V5MigrationHelper {
    public static List<Order> migrate(List<Order> sortBy) {
        List result = null;
        if (sortBy != null) {
            result = sortBy.stream().map(o -> {
                o.setIgnoreCase(true);
                return o;
            }).collect(Collectors.toList());
        }
        return result;
    }

    public static String migrate(PageResponse<?> pageResponse, ObjectMapper objectMapper) throws JsonProcessingException {
        if (pageResponse == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject(objectMapper.writeValueAsString(pageResponse));
        return V5MigrationHelper.migrateToV5((JSONObject)jsonObject, (ObjectMapper)objectMapper);
    }

    public static String migrateToV5(String unmigratedJson) {
        String migratedJson = unmigratedJson.replaceAll("executedSearchTerm", "query");
        migratedJson = migratedJson.replaceAll("searchTerm", "query");
        return migratedJson;
    }

    public static String migrateToV5(JSONObject jsonObject, ObjectMapper objectMapper) {
        JSONObject pageRequest;
        if (jsonObject == null) {
            return null;
        }
        if (jsonObject.has("pageRequest") && (pageRequest = (JSONObject)jsonObject.get("pageRequest")).has("sorting")) {
            JSONObject sorting = (JSONObject)pageRequest.get("sorting");
            if (sorting.has("orders")) {
                JSONArray orders = (JSONArray)sorting.get("orders");
                JSONObject migratedSorting = new JSONObject();
                Iterator it = orders.iterator();
                while (it.hasNext()) {
                    JSONObject order;
                    Direction direction = Direction.fromString((String)((String)(order = (JSONObject)it.next()).get("direction")));
                    order.put("ascending", direction == Direction.ASC);
                    order.put("descending", direction == Direction.DESC);
                    migratedSorting.append("orders", (Object)order);
                }
                pageRequest.put("sorting", (Object)migratedSorting);
            }
            jsonObject.put("pageRequest", (Object)pageRequest);
        }
        return V5MigrationHelper.migrateToV5((String)jsonObject.toString());
    }

    private V5MigrationHelper() {
    }
}

