/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.advice;

import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class ExceptionAdvice {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionAdvice.class);

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={UsernameNotFoundException.class})
    public void handleNotFound() {
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    public void handleHttpMediaTypeNotAcceptableException() {
    }

    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    @ExceptionHandler(value={ValidationException.class})
    public void handleValidationException(Exception exception) {
        LOGGER.error("Cannot process request: ", (Throwable)exception);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public void handleAllOther(Exception exception) {
        LOGGER.error("exception stack trace", (Throwable)exception);
    }
}

