/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.commons.springmvc.thymeleaf.SpacesDialect;
import de.digitalcollections.cudami.server.interceptors.RequestIdLoggingInterceptor;
import de.digitalcollections.model.jackson.DigitalCollectionsObjectMapper;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.datetime.standard.DateTimeFormatterRegistrar;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.thymeleaf.dialect.AbstractProcessorDialect;

@Configuration
public class SpringConfigWeb
implements WebMvcConfigurer {
    @Bean
    @Primary
    public ObjectMapper objectMapper() {
        return new DigitalCollectionsObjectMapper();
    }

    @Bean
    public FormattingConversionService conversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService(false);
        DateTimeFormatterRegistrar registrar = new DateTimeFormatterRegistrar();
        registrar.setDateFormatter(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        registrar.setDateTimeFormatter(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss"));
        registrar.registerFormatters((FormatterRegistry)conversionService);
        return conversionService;
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUseRegisteredSuffixPatternMatch(Boolean.TRUE);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorParameter(true).favorPathExtension(true).ignoreUnknownPathExtensions(true).useRegisteredExtensionsOnly(false).defaultContentType(new MediaType[]{MediaType.APPLICATION_JSON}).mediaTypes(Map.of("html", MediaType.TEXT_HTML, "json", MediaType.APPLICATION_JSON, "xml", MediaType.APPLICATION_XML));
    }

    @Bean
    public AbstractProcessorDialect whiteSpaceNormalizedDialect() {
        return new SpacesDialect();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new RequestIdLoggingInterceptor());
    }
}

