/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.converter;

import de.digitalcollections.model.paging.Direction;
import de.digitalcollections.model.paging.NullHandling;
import de.digitalcollections.model.paging.Order;
import de.digitalcollections.model.paging.OrderBuilder;
import de.digitalcollections.model.paging.Sorting;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Component
public class StringToOrderConverter
implements GenericConverter {
    private final Pattern ORDER_PATTERN = Pattern.compile("^(?<property>[A-Za-z]+)(_(?<subProperty>[A-Za-z]+))?(\\.(?<direction>asc|desc))?(\\.(?<nullHandling>nullsfirst|nullslast))?$");

    public Order convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        String direction;
        if (source == null) {
            return null;
        }
        String propertyString = (String)source;
        Matcher matcher = this.ORDER_PATTERN.matcher(propertyString);
        if (!matcher.matches()) {
            return null;
        }
        OrderBuilder order = Order.defaultBuilder();
        String property = matcher.group("property");
        order.property(property);
        String subProperty = matcher.group("subProperty");
        if (subProperty != null) {
            order.subProperty(subProperty);
        }
        if ((direction = matcher.group("direction")) != null) {
            order.direction(Direction.fromString((String)direction));
        } else {
            order.direction(Sorting.DEFAULT_DIRECTION);
        }
        String nullHandling = matcher.group("nullHandling");
        if (nullHandling != null) {
            if ("nullsfirst".equals(nullHandling)) {
                order.nullHandling(NullHandling.NULLS_FIRST);
            } else {
                order.nullHandling(NullHandling.NULLS_LAST);
            }
        } else {
            order.nullHandling(NullHandling.NATIVE);
        }
        return order.build();
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        HashSet<GenericConverter.ConvertiblePair> convertibleTypes = new HashSet<GenericConverter.ConvertiblePair>();
        convertibleTypes.add(new GenericConverter.ConvertiblePair(String.class, Order.class));
        return convertibleTypes;
    }
}

