/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.converter;

import de.digitalcollections.cudami.server.controller.converter.StringToFilterCriteriaGenericConverter;
import de.digitalcollections.model.filter.FilterCriterion;
import de.digitalcollections.model.filter.FilterOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class StringToFilterCriteriaGenericConverter<C extends Comparable<C>>
implements GenericConverter {
    @Autowired
    private ConversionService conversionService;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        HashSet<GenericConverter.ConvertiblePair> convertibleTypes = new HashSet<GenericConverter.ConvertiblePair>();
        convertibleTypes.add(new GenericConverter.ConvertiblePair(String.class, FilterCriterion.class));
        return convertibleTypes;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        String operationAndValues = (String)source;
        String[] filterSplit = StringUtils.tokenizeToStringArray((String)operationAndValues, (String)":");
        if (filterSplit == null || filterSplit.length != 2) {
            throw new IllegalArgumentException("More than one or no separator ':' found");
        }
        String operationAcronym = filterSplit[0];
        String operationValue = filterSplit[1];
        FilterOperation filterOperation = FilterOperation.fromValue((String)operationAcronym);
        String[] operationValues = !operationValue.contains(",") ? new String[]{operationValue} : StringUtils.tokenizeToStringArray((String)operationValue, (String)",");
        if (operationValues == null || operationValues.length < 1) {
            throw new IllegalArgumentException("Operation value can't be empty");
        }
        List<String> originalValues = Arrays.asList(operationValues);
        Object convertedSingleValue = null;
        Comparable minValue = null;
        Comparable maxValue = null;
        ArrayList convertedValues = new ArrayList();
        Class targetClass = (Class)targetType.getResolvableType().getGeneric(new int[]{0}).getType();
        if (null == filterOperation) {
            convertedSingleValue = this.conversionService.convert((Object)operationValues[0], targetClass);
        } else {
            switch (1.$SwitchMap$de$digitalcollections$model$filter$FilterOperation[filterOperation.ordinal()]) {
                case 1: {
                    if (operationValues.length != 2) {
                        throw new IllegalArgumentException("For 'btn' operation two values are expected");
                    }
                    Comparable value1 = (Comparable)this.conversionService.convert((Object)operationValues[0], targetClass);
                    Comparable value2 = (Comparable)this.conversionService.convert((Object)operationValues[1], targetClass);
                    if (value1 == null || value2 == null) break;
                    if (value1.compareTo(value2) > 0) {
                        minValue = value2;
                        maxValue = value1;
                        break;
                    }
                    minValue = value1;
                    maxValue = value2;
                    break;
                }
                case 2: 
                case 3: {
                    convertedValues.addAll(originalValues.stream().map(s -> this.conversionService.convert(s, targetClass)).collect(Collectors.toList()));
                    break;
                }
                default: {
                    convertedSingleValue = this.conversionService.convert((Object)operationValues[0], targetClass);
                }
            }
        }
        FilterCriterion fc = new FilterCriterion(null, filterOperation, convertedSingleValue, minValue, maxValue, convertedValues);
        return fc;
    }
}

