/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.entity;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.WebsiteService;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.paging.Order;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import de.digitalcollections.model.paging.Sorting;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Website controller")
public class V2WebsiteController {
    private final ObjectMapper objectMapper;
    private final WebsiteService websiteService;

    public V2WebsiteController(WebsiteService websiteService, ObjectMapper objectMapper) {
        this.websiteService = websiteService;
        this.objectMapper = objectMapper;
    }

    @Operation(summary="Get websites", description="Get a paged and filtered list of websites", responses={@ApiResponse(responseCode="200", description="SearchPageResponse&lt;Website&gt; (<a href=\"https://raw.githubusercontent.com/dbmdz/digitalcollections-model/8.2.1/dc-model/src/main/java/de/digitalcollections/model/api/paging/SearchPageResponse.java\">dc-model &lt; 9.0</a>)", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class), examples={@ExampleObject(name="empty list", externalValue="https://github.com/dbmdz/cudami/raw/main/dc-cudami-server/dc-cudami-server-webapp/src/test/resources/json/v2/websites.json")})})})
    @GetMapping(value={"/v2/websites", "/latest/websites"}, produces={"application/json"})
    public ResponseEntity<String> findAll(@Parameter(name="pageNumber", description="the page number (starting with 0); if unset, defaults to 0.", example="0", schema=@Schema(type="integer")) @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @Parameter(name="pageSize", description="the page size; if unset, defaults to 25", example="25", schema=@Schema(type="integer")) @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @Parameter(name="sortBy", description="the sorting specification; if unset, default to alphabetically ascending sorting of the field 'label')", example="label_de.desc.nullsfirst", schema=@Schema(type="string")) @RequestParam(name="sortBy", required=false) List<Order> sortBy, @Parameter(name="searchTerm", description="the search term, of which the result is filtered (substring match)", example="Test", schema=@Schema(type="string")) @RequestParam(name="searchTerm", required=false) String searchTerm) throws JsonProcessingException {
        SearchPageResponse response;
        SearchPageRequest searchPageRequest = new SearchPageRequest(searchTerm, pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(sortBy);
            searchPageRequest.setSorting(sorting);
        }
        if ((response = this.websiteService.find(searchPageRequest)) == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        JSONObject result = new JSONObject(this.objectMapper.writeValueAsString((Object)response));
        JSONArray websites = (JSONArray)result.get("content");
        for (JSONObject website : websites) {
            website.put("className", (Object)"de.digitalcollections.model.impl.identifiable.entity.WebsiteImpl");
        }
        return new ResponseEntity((Object)result.toString(), HttpStatus.OK);
    }

    @Operation(summary="Get website by uuid", description="Get a website by its uuid", responses={@ApiResponse(responseCode="200", description="Website (<a href=\"https://github.com/dbmdz/digitalcollections-model/raw/8.2.1/dc-model/src/main/java/de/digitalcollections/model/api/identifiable/entity/Website.java\">dc-model &lt; 9.0</a>)", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class), examples={@ExampleObject(name="single website", externalValue="https://github.com/dbmdz/cudami/raw/main/dc-cudami-server/dc-cudami-server-webapp/src/test/resources/json/v2/websites/7ebaf4b1-cf5a-491b-991c-4fd082677ff9.json"), @ExampleObject(name="nonexisting website", value="", description="even for non-existing websites, a status 200 is returned!")})}), @ApiResponse(responseCode="404", description="is never returned, even when no website was found!")})
    @GetMapping(value={"/v2/websites/{uuid}", "/v2/websites/{uuid}.json"}, produces={"application/json"})
    public String findById(@Parameter(name="uuid", description="the UUID of the website", example="7ebaf4b1-cf5a-491b-991c-4fd082677ff9", schema=@Schema(implementation=UUID.class)) @PathVariable UUID uuid) throws JsonProcessingException {
        Website website = (Website)this.websiteService.get(uuid);
        if (website == null) {
            return null;
        }
        JSONObject result = new JSONObject(this.objectMapper.writeValueAsString((Object)website));
        result.put("type", (Object)"ENTITY");
        result.put("entityType", (Object)"WEBSITE");
        JSONArray rootPages = (JSONArray)result.get("rootPages");
        for (JSONObject rootPage : rootPages) {
            rootPage.put("type", (Object)"ENTITY_PART");
            rootPage.put("entityPartType", (Object)"WEBPAGE");
        }
        return result.toString();
    }
}

