/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.entity;

import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.WebsiteService;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.Website;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import de.digitalcollections.model.api.paging.Order;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.api.paging.enums.Direction;
import de.digitalcollections.model.api.paging.enums.NullHandling;
import de.digitalcollections.model.impl.identifiable.entity.WebsiteImpl;
import de.digitalcollections.model.impl.paging.OrderImpl;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import de.digitalcollections.model.impl.paging.SortingImpl;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jsondoc.core.annotation.Api;
import org.jsondoc.core.annotation.ApiMethod;
import org.jsondoc.core.annotation.ApiPathParam;
import org.jsondoc.core.annotation.ApiResponseObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(description="The website controller", name="Website controller")
public class WebsiteController {
    @Autowired
    private WebsiteService service;

    @ApiMethod(description="Get all websites")
    @GetMapping(value={"/latest/websites", "/v2/websites"}, produces={"application/json"})
    @ApiResponseObject
    public PageResponse<Website> findAll(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortField", required=false, defaultValue="lastModified") String sortField, @RequestParam(name="sortDirection", required=false, defaultValue="DESC") Direction sortDirection, @RequestParam(name="nullHandling", required=false, defaultValue="NATIVE") NullHandling nullHandling) {
        OrderImpl order = new OrderImpl(sortDirection, sortField, nullHandling);
        SortingImpl sorting = new SortingImpl(new Order[]{order});
        PageRequestImpl pageRequest = new PageRequestImpl(pageNumber, pageSize, (Sorting)sorting);
        return this.service.find((PageRequest)pageRequest);
    }

    @ApiMethod(description="Get website by uuid")
    @GetMapping(value={"/latest/websites/{uuid}", "/v2/websites/{uuid}"}, produces={"application/json"})
    @ApiResponseObject
    public Website findById(@PathVariable UUID uuid) {
        return (Website)this.service.get(uuid);
    }

    @ApiMethod(description="Save a newly created website")
    @PostMapping(value={"/latest/websites", "/v2/websites"}, produces={"application/json"})
    @ApiResponseObject
    public Website save(@RequestBody Website website, BindingResult errors) throws IdentifiableServiceException {
        return (Website)this.service.save((Identifiable)website);
    }

    @ApiMethod(description="Update a website")
    @PutMapping(value={"/latest/websites/{uuid}", "/v2/websites/{uuid}"}, produces={"application/json"})
    @ApiResponseObject
    public Website update(@PathVariable UUID uuid, @RequestBody Website website, BindingResult errors) throws IdentifiableServiceException {
        assert (Objects.equals(uuid, website.getUuid()));
        return (Website)this.service.update((Identifiable)website);
    }

    @ApiMethod(description="Get count of content trees")
    @GetMapping(value={"/latest/websites/count", "/v2/websites/count"}, produces={"application/json"})
    @ApiResponseObject
    public long count() {
        return this.service.count();
    }

    @ApiMethod(description="Get paged root pages of a website")
    @GetMapping(value={"/latest/websites/{uuid}/rootpages", "/v3/websites/{uuid}/rootpages"}, produces={"application/json"})
    @ApiResponseObject
    public PageResponse<Webpage> getRootPages(@ApiPathParam(description="UUID of the parent webpage, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortField", required=false) String sortField, @RequestParam(name="sortDirection", required=false, defaultValue="DESC") Direction sortDirection, @RequestParam(name="nullHandling", required=false, defaultValue="NATIVE") NullHandling nullHandling) throws IdentifiableServiceException {
        SortingImpl sorting = null;
        if (!StringUtils.isEmpty((Object)sortField)) {
            OrderImpl order = new OrderImpl(sortDirection, sortField, nullHandling);
            sorting = new SortingImpl(new Order[]{order});
        }
        PageRequestImpl pageRequest = new PageRequestImpl(pageNumber, pageSize, sorting);
        return this.service.getRootPages(uuid, (PageRequest)pageRequest);
    }

    @ApiMethod(description="Update the order of a website's rootpages")
    @PutMapping(value={"/latest/websites/{uuid}/rootpages", "/v3/websites/{uuid}/rootpages"}, produces={"application/json"})
    @ApiResponseObject
    public ResponseEntity updateRootPagesOrder(@ApiPathParam(description="UUID of the website") @PathVariable(value="uuid") UUID uuid, @ApiPathParam(description="List of the rootpages") @RequestBody List<Webpage> rootPages) {
        WebsiteImpl website = new WebsiteImpl();
        website.setUuid(uuid);
        boolean successful = this.service.updateRootPagesOrder((Website)website, rootPages);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }
}

